/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.info;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.info.PublicSoftwareInfo;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.info.SoftwareInfoDTO;
import com.atlassian.servicedesk.api.rest.dto.links.LinkFactory;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SoftwareInfoDTOFactory {
    private final LinkFactory linkFactory;
    private final DateDTOFactory dateDTOFactory;
    private final DateTimeFormatter dateTimeFormatter;

    @Autowired
    public SoftwareInfoDTOFactory(LinkFactory linkFactory, DateDTOFactory dateDTOFactory, DateTimeFormatter dateTimeFormatter) {
        this.linkFactory = linkFactory;
        this.dateDTOFactory = dateDTOFactory;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public Function<PublicSoftwareInfo, SoftwareInfoDTO> toDTO(ApplicationUser user) {
        return from -> {
            DateDTO buildDate = this.makeBuildDate(user, (PublicSoftwareInfo)from);
            SelfLinkDTO link = this.linkFactory.start().path("info").build(new Object[0]);
            return SoftwareInfoDTO.builder().setVersion(from.getVersion().toString()).setPlatformVersion(from.getPlatformVersion().toString()).setBuildDate(buildDate).setBuildChangeSet(from.getBuildChangeSet()).setIsLicensedForUse(from.isLicensedForUse()).set_links(link).build();
        };
    }

    private DateDTO makeBuildDate(ApplicationUser user, PublicSoftwareInfo from) {
        DateTimeFormatter formatter = user == null ? this.dateTimeFormatter.withLocale(Locale.ENGLISH).withZone(TimeZone.getTimeZone("Australia/Sydney")) : this.dateTimeFormatter.forUser(user);
        return this.dateDTOFactory.toDTO(formatter, from.getBuildDate().toDate());
    }
}

