/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.info;

import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTO;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class SoftwareInfoDTO {
    private String version;
    private String platformVersion;
    private DateDTO buildDate;
    private String buildChangeSet;
    private Boolean isLicensedForUse;
    private SelfLinkDTO _links;

    @Deprecated
    public SoftwareInfoDTO() {
    }

    private SoftwareInfoDTO(String version, String platformVersion, DateDTO buildDate, String buildChangeSet, Boolean isLicensedForUse, SelfLinkDTO _links) {
        this.version = version;
        this.platformVersion = platformVersion;
        this.buildDate = buildDate;
        this.buildChangeSet = buildChangeSet;
        this.isLicensedForUse = isLicensedForUse;
        this._links = _links;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public DateDTO getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(DateDTO buildDate) {
        this.buildDate = buildDate;
    }

    public String getBuildChangeSet() {
        return this.buildChangeSet;
    }

    public void setBuildChangeSet(String buildChangeSet) {
        this.buildChangeSet = buildChangeSet;
    }

    public Boolean getIsLicensedForUse() {
        return this.isLicensedForUse;
    }

    public void setIsLicensedForUse(Boolean isLicensedForUse) {
        this.isLicensedForUse = isLicensedForUse;
    }

    public SelfLinkDTO get_links() {
        return this._links;
    }

    public void set_links(SelfLinkDTO _links) {
        this._links = _links;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SoftwareInfoDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoftwareInfoDTO that = (SoftwareInfoDTO)o;
        return Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.platformVersion, (Object)that.platformVersion) && Objects.equal((Object)this.buildDate, (Object)that.buildDate) && Objects.equal((Object)this.buildChangeSet, (Object)that.buildChangeSet) && Objects.equal((Object)this.isLicensedForUse, (Object)that.isLicensedForUse) && Objects.equal((Object)this._links, (Object)that._links);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.version, this.platformVersion, this.buildDate, this.buildChangeSet, this.isLicensedForUse, this._links});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.version).add("platformVersion", (Object)this.platformVersion).add("buildDate", (Object)this.buildDate).add("buildChangeSet", (Object)this.buildChangeSet).add("isLicensedForUse", (Object)this.isLicensedForUse).add("_links", (Object)this._links).toString();
    }

    public static final class Builder {
        private String version;
        private String platformVersion;
        private DateDTO buildDate;
        private String buildChangeSet;
        private Boolean isLicensedForUse;
        private SelfLinkDTO _links;

        private Builder() {
        }

        private Builder(SoftwareInfoDTO initialData) {
            this.version = initialData.version;
            this.platformVersion = initialData.platformVersion;
            this.buildDate = initialData.buildDate;
            this.buildChangeSet = initialData.buildChangeSet;
            this.isLicensedForUse = initialData.isLicensedForUse;
            this._links = initialData._links;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public Builder setBuildDate(DateDTO buildDate) {
            this.buildDate = buildDate;
            return this;
        }

        public Builder setBuildChangeSet(String buildChangeSet) {
            this.buildChangeSet = buildChangeSet;
            return this;
        }

        public Builder setIsLicensedForUse(Boolean isLicensedForUse) {
            this.isLicensedForUse = isLicensedForUse;
            return this;
        }

        public Builder set_links(SelfLinkDTO _links) {
            this._links = _links;
            return this;
        }

        public SoftwareInfoDTO build() {
            return new SoftwareInfoDTO(this.version, this.platformVersion, this.buildDate, this.buildChangeSet, this.isLicensedForUse, this._links);
        }
    }
}

