/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.field;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class RequestTypeFieldValueDTO {
    private String value;
    private String label;
    private List<RequestTypeFieldValueDTO> children;

    @Deprecated
    public RequestTypeFieldValueDTO() {
    }

    private RequestTypeFieldValueDTO(String value, String label, Iterable<RequestTypeFieldValueDTO> children) {
        this.value = value;
        this.label = label;
        this.children = children != null ? ImmutableList.copyOf(children) : null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<RequestTypeFieldValueDTO> getChildren() {
        return this.children;
    }

    public void setChildren(List<RequestTypeFieldValueDTO> children) {
        this.children = children != null ? ImmutableList.copyOf(children) : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RequestTypeFieldValueDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTypeFieldValueDTO that = (RequestTypeFieldValueDTO)o;
        return Objects.equal((Object)this.value, (Object)that.value) && Objects.equal((Object)this.label, (Object)that.label) && Objects.equal(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.label, this.children});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("label", (Object)this.label).add("children", this.children).toString();
    }

    public static final class Builder {
        private String value;
        private String label;
        private List<RequestTypeFieldValueDTO> children = Lists.newArrayList();

        private Builder() {
        }

        private Builder(RequestTypeFieldValueDTO initialData) {
            this.value = initialData.value;
            this.label = initialData.label;
            this.children = initialData.children;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setChildren(List<RequestTypeFieldValueDTO> children) {
            this.children = children;
            return this;
        }

        public Builder addChildren(RequestTypeFieldValueDTO children) {
            this.children.add(children);
            return this;
        }

        public Builder addChildren(Iterable<RequestTypeFieldValueDTO> children) {
            for (RequestTypeFieldValueDTO value : children) {
                this.addChildren(children);
            }
            return this;
        }

        public RequestTypeFieldValueDTO build() {
            return new RequestTypeFieldValueDTO(this.value, this.label, this.children);
        }
    }
}

