/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.field;

import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.servicedesk.api.rest.dto.domain.field.RequestTypeFieldValueDTO;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class RequestTypeFieldDTO {
    private String fieldId;
    private String name;
    private String description;
    boolean required;
    private List<RequestTypeFieldValueDTO> validValues;
    private JsonTypeBean jiraSchema;

    @Deprecated
    public RequestTypeFieldDTO() {
    }

    private RequestTypeFieldDTO(String fieldId, String name, String description, boolean required, Iterable<RequestTypeFieldValueDTO> validValues, JsonTypeBean jiraSchema) {
        this.fieldId = fieldId;
        this.name = name;
        this.description = description;
        this.required = required;
        this.validValues = validValues != null ? ImmutableList.copyOf(validValues) : null;
        this.jiraSchema = jiraSchema;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public List<RequestTypeFieldValueDTO> getValidValues() {
        return this.validValues;
    }

    public void setValidValues(List<RequestTypeFieldValueDTO> validValues) {
        this.validValues = validValues != null ? ImmutableList.copyOf(validValues) : null;
    }

    public JsonTypeBean getJiraSchema() {
        return this.jiraSchema;
    }

    public void setJiraSchema(JsonTypeBean jiraSchema) {
        this.jiraSchema = jiraSchema;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RequestTypeFieldDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTypeFieldDTO that = (RequestTypeFieldDTO)o;
        return Objects.equal((Object)this.fieldId, (Object)that.fieldId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.required, (Object)that.required) && Objects.equal(this.validValues, that.validValues) && Objects.equal((Object)this.jiraSchema, (Object)that.jiraSchema);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldId, this.name, this.description, this.required, this.validValues, this.jiraSchema});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fieldId", (Object)this.fieldId).add("name", (Object)this.name).add("description", (Object)this.description).add("required", this.required).add("validValues", this.validValues).add("jiraSchema", (Object)this.jiraSchema).toString();
    }

    public static final class Builder {
        private String fieldId;
        private String name;
        private String description;
        private boolean required;
        private List<RequestTypeFieldValueDTO> validValues = Lists.newArrayList();
        private JsonTypeBean jiraSchema;

        private Builder() {
        }

        private Builder(RequestTypeFieldDTO initialData) {
            this.fieldId = initialData.fieldId;
            this.name = initialData.name;
            this.description = initialData.description;
            this.required = initialData.required;
            this.validValues = initialData.validValues;
            this.jiraSchema = initialData.jiraSchema;
        }

        public Builder setFieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setValidValues(List<RequestTypeFieldValueDTO> validValues) {
            this.validValues = validValues;
            return this;
        }

        public Builder addValidValue(RequestTypeFieldValueDTO validValue) {
            this.validValues.add(validValue);
            return this;
        }

        public Builder addValidValues(Iterable<RequestTypeFieldValueDTO> validValues) {
            for (RequestTypeFieldValueDTO validValue : validValues) {
                this.addValidValue(validValue);
            }
            return this;
        }

        public Builder setJiraSchema(JsonTypeBean jiraSchema) {
            this.jiraSchema = jiraSchema;
            return this;
        }

        public RequestTypeFieldDTO build() {
            return new RequestTypeFieldDTO(this.fieldId, this.name, this.description, this.required, this.validValues, this.jiraSchema);
        }
    }
}

