/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.date;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class DurationDTO {
    private final Long millis;
    private final String friendly;

    @JsonCreator
    public DurationDTO(@JsonProperty(value="millis") Long millis, @JsonProperty(value="friendly") String friendly) {
        this.millis = millis;
        this.friendly = friendly;
    }

    public Long getMillis() {
        return this.millis;
    }

    public String getFriendly() {
        return this.friendly;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DurationDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationDTO that = (DurationDTO)o;
        return Objects.equals(this.getMillis(), that.getMillis()) && Objects.equals(this.getFriendly(), that.getFriendly());
    }

    public int hashCode() {
        return Objects.hash(this.getMillis(), this.getFriendly());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("millis", (Object)this.getMillis()).add("friendly", (Object)this.getFriendly()).toString();
    }

    public static final class Builder {
        private Long millis;
        private String friendly;

        private Builder() {
        }

        private Builder(DurationDTO initialData) {
            this.millis = initialData.getMillis();
            this.friendly = initialData.getFriendly();
        }

        public Builder setMillis(Long millis) {
            this.millis = millis;
            return this;
        }

        public Builder setFriendly(String friendly) {
            this.friendly = friendly;
            return this;
        }

        public DurationDTO build() {
            return new DurationDTO(this.millis, this.friendly);
        }
    }
}

