/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.date;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTO;
import java.time.Instant;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DateDTOFactory {
    private final DateTimeFormatter dateTimeFormatter;

    @Autowired
    public DateDTOFactory(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public DateDTO toDTO(DateTimeFormatter formatter, Date from) {
        if (from == null) {
            return null;
        }
        String iso = formatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format(from);
        String jira = Dates.asTimeString((Date)from);
        String friendly = formatter.withStyle(DateTimeStyle.RELATIVE).format(from);
        Long epochMillis = from.getTime();
        return new DateDTO(iso, jira, friendly, epochMillis);
    }

    public DateDTO toDTO(ApplicationUser user, Date from) {
        if (from == null) {
            return null;
        }
        return this.toDTO(this.dateTimeFormatter.forUser(user), from);
    }

    public DateDTO toDTO(ApplicationUser user, Instant from) {
        if (from == null) {
            return null;
        }
        return this.toDTO(user, new Date(from.toEpochMilli()));
    }
}

