/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.comment;

import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTO;
import com.atlassian.servicedesk.api.rest.dto.links.Linkable;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect
public class CommentDTO
implements Linkable {
    private final String id;
    private final String body;
    @JsonProperty(value="public")
    private final boolean _public;
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    private final UserDTO author;
    private final DateDTO created;
    private final SelfLinkDTO _links;

    @JsonCreator
    public CommentDTO(@JsonProperty(value="id") String id, @JsonProperty(value="body") String body, @JsonProperty(value="public") boolean _public, @JsonProperty(value="author") UserDTO author, @JsonProperty(value="created") DateDTO created, @JsonProperty(value="_links") SelfLinkDTO _links) {
        this.id = id;
        this.body = body;
        this._public = _public;
        this.author = author;
        this.created = created;
        this._links = _links;
    }

    public String getId() {
        return this.id;
    }

    public String getBody() {
        return this.body;
    }

    public boolean get_public() {
        return this._public;
    }

    public UserDTO getAuthor() {
        return this.author;
    }

    public DateDTO getCreated() {
        return this.created;
    }

    public SelfLinkDTO get_links() {
        return this._links;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CommentDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommentDTO that = (CommentDTO)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getBody(), that.getBody()) && Objects.equals(this.get_public(), that.get_public()) && Objects.equals(this.getAuthor(), that.getAuthor()) && Objects.equals(this.getCreated(), that.getCreated()) && Objects.equals(this.get_links(), that.get_links());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getBody(), this.get_public(), this.getAuthor(), this.getCreated(), this.get_links());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("body", (Object)this.getBody()).add("_public", this.get_public()).add("author", (Object)this.getAuthor()).add("created", (Object)this.getCreated()).add("_links", (Object)this.get_links()).toString();
    }

    public static final class Builder {
        private String id;
        private String body;
        private boolean _public;
        private UserDTO author;
        private DateDTO created;
        private SelfLinkDTO _links;

        private Builder() {
        }

        private Builder(CommentDTO initialData) {
            this.id = initialData.getId();
            this.body = initialData.getBody();
            this._public = initialData.get_public();
            this.author = initialData.getAuthor();
            this.created = initialData.getCreated();
            this._links = initialData.get_links();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder set_public(boolean _public) {
            this._public = _public;
            return this;
        }

        public Builder setAuthor(UserDTO author) {
            this.author = author;
            return this;
        }

        public Builder setCreated(DateDTO created) {
            this.created = created;
            return this;
        }

        public Builder set_links(SelfLinkDTO _links) {
            this._links = _links;
            return this;
        }

        public CommentDTO build() {
            return new CommentDTO(this.id, this.body, this._public, this.author, this.created, this._links);
        }
    }
}

