/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.attachment;

import com.atlassian.servicedesk.api.rest.dto.domain.comment.AdditionalCommentDTO;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class AttachmentCreateDTO {
    private final List<String> temporaryAttachmentIds;
    @JsonProperty(value="public")
    private final Boolean _public;
    @Nullable
    private final AdditionalCommentDTO additionalComment;

    @JsonCreator
    public AttachmentCreateDTO(@JsonProperty(value="temporaryAttachmentIds") List<String> temporaryAttachmentIds, @JsonProperty(value="public") Boolean _public, @JsonProperty(value="additionalComment") AdditionalCommentDTO additionalComment) {
        this.temporaryAttachmentIds = temporaryAttachmentIds != null ? ImmutableList.copyOf(temporaryAttachmentIds) : null;
        this._public = _public;
        this.additionalComment = additionalComment;
    }

    public List<String> getTemporaryAttachmentIds() {
        return this.temporaryAttachmentIds;
    }

    public Boolean get_public() {
        return this._public;
    }

    public AdditionalCommentDTO getAdditionalComment() {
        return this.additionalComment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AttachmentCreateDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentCreateDTO that = (AttachmentCreateDTO)o;
        return Objects.equals(this.getTemporaryAttachmentIds(), that.getTemporaryAttachmentIds()) && Objects.equals(this.get_public(), that.get_public()) && Objects.equals(this.getAdditionalComment(), that.getAdditionalComment());
    }

    public int hashCode() {
        return Objects.hash(this.getTemporaryAttachmentIds(), this.get_public(), this.getAdditionalComment());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("temporaryAttachmentIds", this.getTemporaryAttachmentIds()).add("_public", (Object)this.get_public()).add("additionalComment", (Object)this.getAdditionalComment()).toString();
    }

    public static final class Builder {
        private List<String> temporaryAttachmentIds = Lists.newArrayList();
        private Boolean _public;
        private AdditionalCommentDTO additionalComment;

        private Builder() {
        }

        private Builder(AttachmentCreateDTO initialData) {
            this.temporaryAttachmentIds = Lists.newArrayList(initialData.getTemporaryAttachmentIds());
            this._public = initialData.get_public();
            this.additionalComment = initialData.getAdditionalComment();
        }

        public Builder setTemporaryAttachmentIds(List<String> temporaryAttachmentIds) {
            this.temporaryAttachmentIds = temporaryAttachmentIds;
            return this;
        }

        public Builder addTemporaryAttachmentId(String temporaryAttachmentId) {
            this.temporaryAttachmentIds.add(temporaryAttachmentId);
            return this;
        }

        public Builder addTemporaryAttachmentIds(Iterable<String> temporaryAttachmentIds) {
            for (String temporaryAttachmentId : temporaryAttachmentIds) {
                this.addTemporaryAttachmentId(temporaryAttachmentId);
            }
            return this;
        }

        public Builder set_public(Boolean _public) {
            this._public = _public;
            return this;
        }

        public Builder setAdditionalComment(AdditionalCommentDTO additionalComment) {
            this.additionalComment = additionalComment;
            return this;
        }

        public AttachmentCreateDTO build() {
            return new AttachmentCreateDTO(this.temporaryAttachmentIds, this._public, this.additionalComment);
        }
    }
}

