/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.approval;

import com.atlassian.servicedesk.api.rest.dto.domain.approval.ApprovalDecisionResponseType;
import com.atlassian.servicedesk.api.rest.dto.domain.approval.ApproverDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTO;
import com.atlassian.servicedesk.api.rest.dto.links.Linkable;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class ApprovalDTO
implements Linkable {
    private final String id;
    private final String name;
    private final ApprovalDecisionResponseType finalDecision;
    private final boolean canAnswerApproval;
    private final List<ApproverDTO> approvers;
    private final DateDTO createdDate;
    @Nullable
    private final DateDTO completedDate;
    private final SelfLinkDTO _links;

    @JsonCreator
    public ApprovalDTO(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="finalDecision") ApprovalDecisionResponseType finalDecision, @JsonProperty(value="canAnswerApproval") boolean canAnswerApproval, @JsonProperty(value="approvers") List<ApproverDTO> approvers, @JsonProperty(value="createdDate") DateDTO createdDate, @JsonProperty(value="completedDate") DateDTO completedDate, @JsonProperty(value="_links") SelfLinkDTO _links) {
        this.id = id;
        this.name = name;
        this.finalDecision = finalDecision;
        this.canAnswerApproval = canAnswerApproval;
        this.approvers = approvers != null ? ImmutableList.copyOf(approvers) : null;
        this.createdDate = createdDate;
        this.completedDate = completedDate;
        this._links = _links;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ApprovalDecisionResponseType getFinalDecision() {
        return this.finalDecision;
    }

    public boolean getCanAnswerApproval() {
        return this.canAnswerApproval;
    }

    public List<ApproverDTO> getApprovers() {
        return this.approvers;
    }

    public DateDTO getCreatedDate() {
        return this.createdDate;
    }

    public DateDTO getCompletedDate() {
        return this.completedDate;
    }

    public SelfLinkDTO get_links() {
        return this._links;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ApprovalDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalDTO that = (ApprovalDTO)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals((Object)this.getFinalDecision(), (Object)that.getFinalDecision()) && Objects.equals(this.getCanAnswerApproval(), that.getCanAnswerApproval()) && Objects.equals(this.getApprovers(), that.getApprovers()) && Objects.equals(this.getCreatedDate(), that.getCreatedDate()) && Objects.equals(this.getCompletedDate(), that.getCompletedDate()) && Objects.equals(this.get_links(), that.get_links());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getId(), this.getName(), this.getFinalDecision(), this.getCanAnswerApproval(), this.getApprovers(), this.getCreatedDate(), this.getCompletedDate(), this.get_links()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("finalDecision", (Object)this.getFinalDecision()).add("canAnswerApproval", this.getCanAnswerApproval()).add("approvers", this.getApprovers()).add("createdDate", (Object)this.getCreatedDate()).add("completedDate", (Object)this.getCompletedDate()).add("_links", (Object)this.get_links()).toString();
    }

    public static final class Builder {
        private String id;
        private String name;
        private ApprovalDecisionResponseType finalDecision;
        private boolean canAnswerApproval;
        private List<ApproverDTO> approvers = Lists.newArrayList();
        private DateDTO createdDate;
        private DateDTO completedDate;
        private SelfLinkDTO _links;

        private Builder() {
        }

        private Builder(ApprovalDTO initialData) {
            this.id = initialData.getId();
            this.name = initialData.getName();
            this.finalDecision = initialData.getFinalDecision();
            this.canAnswerApproval = initialData.getCanAnswerApproval();
            this.approvers = Lists.newArrayList(initialData.getApprovers());
            this.createdDate = initialData.getCreatedDate();
            this.completedDate = initialData.getCompletedDate();
            this._links = initialData.get_links();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setFinalDecision(ApprovalDecisionResponseType finalDecision) {
            this.finalDecision = finalDecision;
            return this;
        }

        public Builder setCanAnswerApproval(boolean canAnswerApproval) {
            this.canAnswerApproval = canAnswerApproval;
            return this;
        }

        public Builder setApprovers(List<ApproverDTO> approvers) {
            this.approvers = approvers;
            return this;
        }

        public Builder addApprover(ApproverDTO approver) {
            this.approvers.add(approver);
            return this;
        }

        public Builder addApprovers(Iterable<ApproverDTO> approvers) {
            for (ApproverDTO approver : approvers) {
                this.addApprover(approver);
            }
            return this;
        }

        public Builder setCreatedDate(DateDTO createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder setCompletedDate(DateDTO completedDate) {
            this.completedDate = completedDate;
            return this;
        }

        public Builder set_links(SelfLinkDTO _links) {
            this._links = _links;
            return this;
        }

        public ApprovalDTO build() {
            return new ApprovalDTO(this.id, this.name, this.finalDecision, this.canAnswerApproval, this.approvers, this.createdDate, this.completedDate, this._links);
        }
    }
}

