/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.workflow.importer;

import com.atlassian.jira.util.I18nHelper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class I18nWorkflowXmlProcessor {
    public String process(I18nHelper i18n, String workflowXML) {
        Document document = Jsoup.parse((String)workflowXML, (String)"", (Parser)Parser.xmlParser());
        this.i18nAttributes(i18n, document.select("step"), "name");
        this.i18nAttributes(i18n, document.select("action"), "name");
        this.duplicateElements(document.select("meta[name=jira.description]"), "name", "jira.i18n.description");
        this.i18nText(i18n, document.select("meta[name=jira.description]"));
        document.select("meta[name=jira.update.author.key]").html(i18n.getText("sd.workflow.author"));
        document.outputSettings(new Document.OutputSettings().syntax(Document.OutputSettings.Syntax.xml).prettyPrint(false).escapeMode(Entities.EscapeMode.xhtml));
        return document.toString();
    }

    private void duplicateElements(Elements elements, String attrName, String attrValue) {
        for (Element element : elements) {
            Element copy = element.before("<" + element.tagName() + "/>").previousElementSibling();
            copy.attr(attrName, attrValue);
            copy.text(element.text());
        }
    }

    private void i18nText(I18nHelper i18n, Elements elements) {
        for (Element element : elements) {
            String text = element.text();
            element.text(i18n.getText(text));
        }
    }

    private void i18nAttributes(I18nHelper i18n, Elements elements, String attributeKey) {
        for (Element element : elements) {
            element.attr(attributeKey, i18n.getText(element.attr(attributeKey)));
        }
    }
}

