/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web.soy.functions;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToJsonFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final Logger log = LoggerFactory.getLogger(ToJsonFunction.class);
    private static final Set<Integer> VALID_ARG_SIZES = ImmutableSet.of((Object)1);
    private static final CharMatcher SEPARATORS = CharMatcher.anyOf((CharSequence)"\u2028\u2029");
    private final JsonFactory jsonFactory = new ObjectMapper().getJsonFactory();

    public JsExpression generate(JsExpression ... args) {
        return new JsExpression("JSON.stringify(" + args[0].getText() + ").replace(/\\//g, '\\\\/')");
    }

    public String getName() {
        return "toJson";
    }

    public String apply(Object ... objects) {
        return this.safeJson(this.render(objects[0]));
    }

    private String render(Object obj) {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator generator = this.jsonFactory.createJsonGenerator((Writer)writer);
            generator.writeObject(obj);
            generator.close();
            return writer.toString();
        }
        catch (IOException e) {
            log.error(String.format("Failed to render JSON for object of type %s", obj.getClass().getName()), (Throwable)e);
            return "";
        }
    }

    private String safeJson(String json) {
        return SEPARATORS.replaceFrom((CharSequence)json, (CharSequence)"\\n");
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

