/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web.pagedata.settings;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.json.JsonMarshallingException;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.atlassian.servicedesk.internal.api.rest.responses.kb.ConfluenceKBLinkResponse;
import com.atlassian.servicedesk.internal.web.pagedata.settings.KBLinkParams;
import com.atlassian.servicedesk.internal.web.pagedata.settings.KnowledgeBaseSettingsPageDataProvider;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KnowledgeBaseSettingsPageDataProviderImpl
implements KnowledgeBaseSettingsPageDataProvider {
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;
    private final ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    private final I18nHelper i18NHelper;
    private final ServiceDeskService serviceDeskService;

    @Autowired
    public KnowledgeBaseSettingsPageDataProviderImpl(ServiceDeskAppLinkService serviceDeskAppLinkService, ConfluenceKnowledgeBaseService confluenceKnowleedgeBaseService, ServiceDeskPermissionService serviceDeskPermissionService, I18nHelper i18NHelper, ServiceDeskService serviceDeskService) {
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
        this.confluenceKnowledgeBaseService = confluenceKnowleedgeBaseService;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.jaxbJsonMarshaller = DefaultJaxbJsonMarshaller.builder().build();
        this.i18NHelper = i18NHelper;
        this.serviceDeskService = serviceDeskService;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, KBLinkParams> getData(CheckedUser user, Project project) {
        return Steps.begin((io.atlassian.fugue.Either)this.serviceDeskAppLinkService.getAllApplicationLinksForType(user, project, ConfluenceApplicationType.class)).then(links -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project))).then((links, serviceDesk) -> StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(user.forJIRA(), serviceDesk))).then((links, serviceDesk, isAdminAgent2) -> this.getKbLinkParams(user.forJIRA(), project, (List<ApplicationLink>)links, (Boolean)isAdminAgent2)).yield((links, serviceDesk, isAdminAgent2, kbLinkParams) -> kbLinkParams);
    }

    private io.atlassian.fugue.Either<AnError, KBLinkParams> getKbLinkParams(ApplicationUser user, Project project, List<ApplicationLink> links, Boolean isAdminAgent2) {
        return io.atlassian.fugue.Either.right((Object)this.confluenceKnowledgeBaseService.getKBLink(user, project).fold(error -> this.createEmptyKbLinkParams(links, project, isAdminAgent2), kbLink -> this.createKbLinkParams(links, (ConfluenceKnowledgeBaseLink)kbLink, ConfluenceKBLinkResponse.toConfluenceKBLinkResponse((ConfluenceKnowledgeBaseLink)kbLink), project, isAdminAgent2)));
    }

    private Boolean hasAppLinks(List<ApplicationLink> links, ConfluenceKnowledgeBaseLink kbLink) {
        return links.stream().map(link -> link.getId().get().equals(kbLink.getApplicationId())).collect(Collectors.toList()).contains(true);
    }

    private String getKbLinkError(List<ApplicationLink> links, ConfluenceKnowledgeBaseLink kbLink) {
        if (this.hasAppLinks(links, kbLink).booleanValue()) {
            return null;
        }
        return this.i18NHelper.getText("sd.kb.invalidLink");
    }

    private KBLinkParams createKbLinkParams(List<ApplicationLink> links, ConfluenceKnowledgeBaseLink kbLink, ConfluenceKBLinkResponse kbLinkResponse, Project project, Boolean isAdminAgent2) {
        return new KBLinkParams(this.getKbLinkJson(kbLinkResponse), this.getKbLinkError(links, kbLink), kbLinkResponse, this.hasAppLinks(links, kbLink), project.getName(), false, isAdminAgent2);
    }

    private KBLinkParams createEmptyKbLinkParams(List<ApplicationLink> links, Project project, Boolean isAdminAgent2) {
        return new KBLinkParams(null, null, null, links.size() > 0, project.getName(), false, isAdminAgent2);
    }

    private String getKbLinkJson(ConfluenceKBLinkResponse kbLinkResponse) {
        try {
            return this.jaxbJsonMarshaller.marshal((Object)kbLinkResponse);
        }
        catch (JsonMarshallingException e) {
            return null;
        }
    }
}

