/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.web.ProjectUrlsImpl;
import com.atlassian.servicedesk.internal.web.UrlProvider;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ProjectUrlsProviderImpl
extends UrlProvider
implements ProjectUrlsProvider {
    @Autowired
    public ProjectUrlsProviderImpl(WebResourceUrlProvider webResourceUrlProvider) {
        super(webResourceUrlProvider);
    }

    public ProjectUrls getUrls(String projectKey, ProjectUrlsProvider.UrlMode urlMode) {
        URI projectUrl = this.projectBase(projectKey, urlMode);
        URI settingsUrl = this.settingsBase(projectKey, urlMode);
        return new ProjectUrlsImpl(projectUrl, settingsUrl);
    }

    private URI projectBase(String projectKey, ProjectUrlsProvider.UrlMode urlMode) {
        Preconditions.checkNotNull((Object)urlMode);
        Preconditions.checkNotNull((Object)projectKey);
        UriBuilder base = UriBuilder.fromUri((URI)this.baseUrl(urlMode));
        return base.path("projects").path(projectKey).build(new Object[0]);
    }

    private URI settingsBase(String projectKey, ProjectUrlsProvider.UrlMode urlMode) {
        Preconditions.checkNotNull((Object)urlMode);
        Preconditions.checkNotNull((Object)projectKey);
        UriBuilder base = UriBuilder.fromUri((URI)this.baseUrl(urlMode));
        return base.path("servicedesk").path("admin").path(projectKey).build(new Object[0]);
    }
}

