/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.servicedesk.internal.api.project.PortalUrls;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.web.PortalUrlsImpl;
import com.atlassian.servicedesk.internal.web.UrlProvider;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class PortalUrlsProviderImpl
extends UrlProvider
implements PortalUrlsProvider {
    @Autowired
    public PortalUrlsProviderImpl(WebResourceUrlProvider webResourceUrlProvider) {
        super(webResourceUrlProvider);
    }

    public PortalUrls getUrls(int portalId, ProjectUrlsProvider.UrlMode urlMode) {
        URI helpCentreUrl = this.helpCentreUrl(urlMode);
        URI portalUrl = this.portalBase(portalId, urlMode);
        return new PortalUrlsImpl(helpCentreUrl, portalUrl);
    }

    public PortalUrls getUrls(ProjectUrlsProvider.UrlMode urlMode) {
        URI helpCentreUrl = this.helpCentreUrl(urlMode);
        return new PortalUrlsImpl(helpCentreUrl);
    }

    private URI portalBase(int projectId, ProjectUrlsProvider.UrlMode urlMode) {
        Preconditions.checkNotNull((Object)urlMode);
        UriBuilder base = UriBuilder.fromUri((URI)this.baseUrl(urlMode));
        return base.path("servicedesk").path("customer").path("portal").path(String.valueOf(projectId)).build(new Object[0]);
    }

    private URI helpCentreUrl(ProjectUrlsProvider.UrlMode urlMode) {
        Preconditions.checkNotNull((Object)urlMode);
        UriBuilder base = UriBuilder.fromUri((URI)this.baseUrl(urlMode));
        return base.path("servicedesk").path("customer").path("portals").build(new Object[0]);
    }
}

