/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web;

import com.atlassian.servicedesk.internal.api.condition.SDOperationalConditionHelper;
import com.atlassian.servicedesk.internal.api.eyeball.EyeballService;
import com.atlassian.servicedesk.internal.web.OperationalStatusAwareHttpFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class PopulateEyeballForRestFilter
extends OperationalStatusAwareHttpFilter {
    private static final String[] IGNORE_EYEBALL_URL_PREFIXES = new String[]{"/rest/servicedesk/noeyeball", "/rest/servicedesk/project-ui/noeyeball"};
    private final EyeballService eyeballService;

    @Autowired
    public PopulateEyeballForRestFilter(EyeballService eyeballService, SDOperationalConditionHelper sdOperationalConditionHelper) {
        super(sdOperationalConditionHelper);
        this.eyeballService = eyeballService;
    }

    @Override
    protected void doFilterWhenLicensed(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (!this.ignoreEyeball(request)) {
            this.eyeballService.tagSDEvent();
        }
    }

    private boolean ignoreEyeball(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String requestUri = request.getRequestURI().replaceFirst(contextPath, "");
        for (int i = 0; i < IGNORE_EYEBALL_URL_PREFIXES.length; ++i) {
            if (!requestUri.startsWith(IGNORE_EYEBALL_URL_PREFIXES[i])) continue;
            return true;
        }
        return false;
    }
}

