/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.seraph.util.RedirectUtils;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskOperationalStatus;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import com.atlassian.servicedesk.internal.feature.servicedesk.suggested.SDSuggestedItem;
import com.atlassian.servicedesk.internal.feature.servicedesk.suggested.ServiceDeskSuggestedService;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetStartedServlet
extends HttpServlet {
    private final ServiceDeskOperationalStatus serviceDeskOperationalStatus;
    private final UserFactory userFactory;
    private final ServiceDeskSuggestedService serviceDeskSuggestedService;
    private final PermissionService permissionService;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final ProjectUrlsProvider projectUrlsProvider;

    public GetStartedServlet(ServiceDeskOperationalStatus serviceDeskOperationalStatus, UserFactory userFactory, ServiceDeskSuggestedService serviceDeskSuggestedService, PermissionService permissionService, ServiceDeskPermissions serviceDeskPermissions, ProjectUrlsProvider projectUrlsProvider) {
        this.serviceDeskOperationalStatus = serviceDeskOperationalStatus;
        this.userFactory = userFactory;
        this.serviceDeskSuggestedService = serviceDeskSuggestedService;
        this.permissionService = permissionService;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.projectUrlsProvider = projectUrlsProvider;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.serviceDeskOperationalStatus.isOperational()) {
            String getStartedRedirectUrl = this.getStartedRedirectUrl(request);
            response.sendRedirect(getStartedRedirectUrl);
        } else {
            response.sendRedirect(this.getJiraHomeUrl(request));
        }
    }

    protected String getStartedRedirectUrl(HttpServletRequest request) {
        io.atlassian.fugue.Either checkedUserEither = StepsConverters.newerEither((Either)this.userFactory.getCheckedUser());
        if (checkedUserEither.isLeft()) {
            return this.getJiraHomeUrl(request);
        }
        CheckedUser user = (CheckedUser)checkedUserEither.right().get();
        List<SDSuggestedItem> suggestedItems = this.serviceDeskSuggestedService.getSDSuggested(user);
        if (suggestedItems.isEmpty()) {
            if (this.permissionService.canBrowseSomeProject(user.forJIRA())) {
                return this.getBrowseServiceDeskProjectUrl(request);
            }
            if (this.isJiraAdmin(user)) {
                return this.getAdministerProjectsUrl(request);
            }
            return this.getCannotViewUrl(request);
        }
        return this.getAgentViewUrl(suggestedItems.get(0).getProject().getKey());
    }

    private String getJiraHomeUrl(HttpServletRequest request) {
        return RedirectUtils.getServerNameAndPath((HttpServletRequest)request) + "/secure/MyJiraHome.jspa";
    }

    private String getAdministerProjectsUrl(HttpServletRequest request) {
        return RedirectUtils.getServerNameAndPath((HttpServletRequest)request) + "/secure/project/ViewProjects.jspa";
    }

    private String getAgentViewUrl(String projectKey) {
        ProjectUrls urls = this.projectUrlsProvider.getUrls(projectKey, ProjectUrlsProvider.UrlMode.RELATIVE);
        return urls.projectBase().toString();
    }

    private String getCannotViewUrl(HttpServletRequest request) {
        return RedirectUtils.getServerNameAndPath((HttpServletRequest)request) + "/servicedesk/cannot-view";
    }

    private String getBrowseServiceDeskProjectUrl(HttpServletRequest request) {
        return RedirectUtils.getServerNameAndPath((HttpServletRequest)request) + "/secure/BrowseProjects.jspa?selectedProjectType=service_desk";
    }

    private boolean isJiraAdmin(CheckedUser user) {
        return this.serviceDeskPermissions.canAdministerJIRA((SDUser)user);
    }
}

