/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.customer.NoExceptionsCallable;
import com.atlassian.servicedesk.internal.customer.context.module.CustomerContextModuleManager;
import com.atlassian.servicedesk.internal.customer.context.urimatching.UriMatch;
import com.atlassian.servicedesk.internal.customer.context.urimatching.UriMatcher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class CustomerContextSettingFilter
extends AbstractHttpFilter {
    private final UriMatcher STATIC_DEFINITIONS = new UriMatcher((ImmutableList<UriMatch>)ImmutableList.of((Object)UriMatch.builder().startsWith("/servicedesk").addPattern("/lost.*").addPattern("/customer.*").build(), (Object)UriMatch.builder().startsWith("/rest/servicedesk/").addPattern("knowledgebase/latest/articles/search.*").build(), (Object)UriMatch.builder().startsWith("/rest/servicedesk/1").addPattern("/customer.*").build(), (Object)UriMatch.builder().startsWith("/rest/servicedesk/1/servicedesk").addPattern("/customer.*").addPattern("/.*/kb/.*/article.*").addPattern("/sharedportal/kb/articles.*").addPattern("/request-type-search.*").build(), (Object)UriMatch.builder().startsWith("/rest/auth").addPattern("/1/session").addPattern("/latest/session").build(), (Object)UriMatch.builder().startsWith("/rest/api/2").addPattern("/mypermissions").addPattern("/myself").addPattern("/serverInfo").build(), (Object)UriMatch.builder().startsWith("/rest/api/latest").addPattern("/mypermissions").addPattern("/myself").addPattern("/serverInfo").build(), (Object)UriMatch.builder().startsWith("/rest/api").setBlackList().addPattern(".*").build()));
    private final CustomerContextService customerContextService;
    private final CustomerContextModuleManager customerContextModuleManager;
    private static final String ALREADY_RAN = CustomerContextSettingFilter.class.getCanonicalName();

    public CustomerContextSettingFilter(CustomerContextService customerContextService, CustomerContextModuleManager customerContextModuleManager) {
        this.customerContextService = customerContextService;
        this.customerContextModuleManager = customerContextModuleManager;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request.getAttribute(ALREADY_RAN) != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.setAttribute(ALREADY_RAN, (Object)Boolean.TRUE);
        this.doFilterImpl(request, response, filterChain);
    }

    private void doFilterImpl(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String requestPath = this.requestPathSansContext(request);
        if (this.runInCustomerContext(requestPath)) {
            this.inCustomerContext(request, response, filterChain);
        } else {
            this.outOfCustomerContext(request, response, filterChain);
        }
    }

    @VisibleForTesting
    boolean runInCustomerContext(String requestPath) {
        UriMatcher.Decision decision = this.runUriMatcher(requestPath, this.STATIC_DEFINITIONS);
        if (decision == UriMatcher.Decision.GRANTED) {
            return true;
        }
        if (decision == UriMatcher.Decision.DENIED) {
            return false;
        }
        decision = this.runUriMatcher(requestPath, this.buildDynamicDefinitions());
        if (decision == UriMatcher.Decision.GRANTED) {
            return true;
        }
        if (decision == UriMatcher.Decision.DENIED) {
            return false;
        }
        return false;
    }

    private UriMatcher.Decision runUriMatcher(String requestPath, UriMatcher uriMatcher) {
        return uriMatcher.matches(requestPath);
    }

    private UriMatcher buildDynamicDefinitions() {
        return this.customerContextModuleManager.getUriMatcher();
    }

    private String requestPathSansContext(HttpServletRequest request) {
        String contextPath = StringUtils.defaultString((String)request.getContextPath());
        String requestPath = StringUtils.defaultString((String)request.getRequestURI());
        return StringUtils.substringAfter((String)requestPath, (String)contextPath);
    }

    private void inCustomerContext(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ExceptionCapture exceptionCapture = (ExceptionCapture)this.customerContextService.runInCustomerContext(this.invokeFilterChain(request, response, filterChain));
        exceptionCapture.rethrowIfCaptured();
    }

    private void outOfCustomerContext(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ExceptionCapture exceptionCapture = (ExceptionCapture)this.customerContextService.runOutOfCustomerContext(this.invokeFilterChain(request, response, filterChain));
        exceptionCapture.rethrowIfCaptured();
    }

    private NoExceptionsCallable<ExceptionCapture> invokeFilterChain(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        return () -> {
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return ExceptionCapture.EMPTY;
            }
            catch (IOException e) {
                return new ExceptionCapture(e);
            }
            catch (ServletException e) {
                return new ExceptionCapture(e);
            }
        };
    }

    private static class ExceptionCapture {
        public static final ExceptionCapture EMPTY = new ExceptionCapture();
        private final Exception exception;

        ExceptionCapture() {
            this.exception = null;
        }

        ExceptionCapture(IOException exception) {
            this.exception = exception;
        }

        ExceptionCapture(ServletException exception) {
            this.exception = exception;
        }

        void rethrowIfCaptured() throws IOException, ServletException {
            if (this.exception == null) {
                return;
            }
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            if (this.exception instanceof ServletException) {
                throw (ServletException)this.exception;
            }
        }
    }
}

