/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.visiblefortesting.WorkflowTransitionConfigurationBackdoor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class WorkflowTransitionConfigurationBackdoorImpl
implements WorkflowTransitionConfigurationBackdoor {
    private final WorkflowService workflowService;
    private final ErrorResultHelper errorResultHelper;
    private final FieldScreenManager fieldScreenManager;

    @Autowired
    public WorkflowTransitionConfigurationBackdoorImpl(WorkflowService workflowService, ErrorResultHelper errorResultHelper, FieldScreenManager fieldScreenManager) {
        this.workflowService = workflowService;
        this.errorResultHelper = errorResultHelper;
        this.fieldScreenManager = fieldScreenManager;
    }

    public Either<AnError, Unit> setProperty(ApplicationUser user, String workflowName, int transitionId, String key, String value) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("key", key);
        args.put("value", value);
        return this.updateTransitionSetting(user, workflowName, transitionId, "property", args);
    }

    public Either<AnError, Unit> publishWorkflow(ApplicationUser user, String workflowName) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        return this.publishWorkflow(workflowName, (JiraServiceContext)serviceContext);
    }

    public Either<AnError, Unit> setScreen(ApplicationUser user, String workflowName, int transitionId, boolean withScreen) {
        HashMap<String, Boolean> args = new HashMap<String, Boolean>();
        args.put("present", withScreen);
        return this.updateTransitionSetting(user, workflowName, transitionId, "screen", args);
    }

    private Either<AnError, Unit> updateTransitionSetting(ApplicationUser user, String workflowName, int transitionId, String type, Map args) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        JiraWorkflow draftWorkflow = this.workflowService.createDraftWorkflow((JiraServiceContext)serviceContext, workflowName);
        if (draftWorkflow == null) {
            return Either.left((Object)this.errorResultHelper.internalServiceError500("Failed to create draft workflow", new Object[0]).build());
        }
        WorkflowDescriptor wd = draftWorkflow.getDescriptor();
        if (wd == null) {
            return Either.left((Object)this.errorResultHelper.internalServiceError500("Get Workflow failed", new Object[0]).build());
        }
        ActionDescriptor ad = wd.getAction(transitionId);
        if (ad == null) {
            return Either.left((Object)this.errorResultHelper.internalServiceError500("Get Action Descriptor Failed", new Object[0]).build());
        }
        if (type.equals("screen")) {
            this.setActionScreen(ad, (FieldScreen)this.fieldScreenManager.getFieldScreens().stream().findFirst().get(), (Boolean)args.get("present"));
        } else if (type.equals("property")) {
            Map metaAttributes = ad.getMetaAttributes();
            metaAttributes.put(args.get("key"), args.get("value"));
            ad.setMetaAttributes(metaAttributes);
        }
        this.workflowService.updateWorkflow((JiraServiceContext)serviceContext, draftWorkflow);
        return this.publishWorkflow(workflowName, (JiraServiceContext)serviceContext);
    }

    private Either<AnError, Unit> publishWorkflow(String workflowName, JiraServiceContext serviceContext) {
        this.workflowService.overwriteActiveWorkflow(serviceContext, workflowName);
        if (serviceContext.getErrorCollection().hasAnyErrors()) {
            return Either.left((Object)this.errorResultHelper.internalServiceError500("Failed to publish", new Object[0]).build());
        }
        return Either.right((Object)Unit.Unit());
    }

    private Unit setActionScreen(ActionDescriptor actionDescriptor, FieldScreen screen, boolean withScreen) {
        if (withScreen) {
            actionDescriptor.setView("fieldscreen");
            actionDescriptor.getMetaAttributes().put("jira.fieldscreen.id", screen.getId().toString());
        } else {
            actionDescriptor.setView(null);
            actionDescriptor.getMetaAttributes().put("jira.fieldscreen.id", null);
        }
        return Unit.Unit();
    }
}

