/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.visiblefortesting.ServiceDeskWorkflowPermissionServiceBackdoor;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import com.atlassian.servicedesk.internal.workflow.ServiceDeskJiraWorkflowManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class ServiceDeskWorkflowPermissionServiceBackdoorImpl
implements ServiceDeskWorkflowPermissionServiceBackdoor {
    private final ServiceDeskJiraWorkflowManager serviceDeskJiraWorkflowManager;
    private final WorkflowService workflowService;
    private final IssueHelper issueHelper;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public ServiceDeskWorkflowPermissionServiceBackdoorImpl(ServiceDeskJiraWorkflowManager serviceDeskJiraWorkflowManager, WorkflowService workflowService, IssueHelper issueHelper, ErrorResultHelper errorResultHelper) {
        this.serviceDeskJiraWorkflowManager = serviceDeskJiraWorkflowManager;
        this.workflowService = workflowService;
        this.issueHelper = issueHelper;
        this.errorResultHelper = errorResultHelper;
    }

    public Either<AnError, Unit> addUserOnlyPermissionToWorkflow(CheckedUser checkedUser, String issueKey, String metaPermissionKey, String username) {
        return this.doUpdateUserOnlyPermissionToWorkflow(checkedUser, issueKey, metaPermissionKey, username, true);
    }

    public Either<AnError, Unit> removeUserOnlyPermissionToWorkflow(CheckedUser checkedUser, String issueKey, String metaPermissionKey, String username) {
        return this.doUpdateUserOnlyPermissionToWorkflow(checkedUser, issueKey, metaPermissionKey, username, false);
    }

    private Either<AnError, Unit> doUpdateUserOnlyPermissionToWorkflow(CheckedUser checkedUser, String issueKey, String metaPermissionKey, String username, boolean adding) {
        return Steps.begin(this.issueHelper.getIssueByKey(checkedUser, issueKey)).then(issue -> this.getDraftWorkflowFromIssue(checkedUser, (Issue)issue)).then((issue, jiraWorkflow) -> Option.option((Object)jiraWorkflow.getLinkedStep(issue.getStatus())).toRight(() -> this.errorResultHelper.badRequest400("No step for issue status : " + issue.getStatus() + " on issue " + issueKey, new Object[0]).build())).then((issue, jiraWorkflow, stepDescriptor) -> {
            String key = "jira.permission." + StringUtils.lowerCase((String)metaPermissionKey) + ".user";
            if (adding) {
                stepDescriptor.getMetaAttributes().put(key, username);
            } else {
                stepDescriptor.getMetaAttributes().remove(key, username);
            }
            return this.updateAndPublishWorkflow(checkedUser, (JiraWorkflow)jiraWorkflow);
        }).yield((issue, jiraWorkflow, stepDescriptor, unit) -> Unit.Unit());
    }

    private Either<AnError, JiraWorkflow> getDraftWorkflowFromIssue(CheckedUser checkedUser, Issue issue) {
        return Steps.begin(this.serviceDeskJiraWorkflowManager.getWorkflowForIssue(issue)).then(() -> Either.right((Object)this.createJiraServiceContext(checkedUser))).then((serviceDeskManagedJiraWorkflow, jiraServiceContext) -> Option.option((Object)this.workflowService.createDraftWorkflow(jiraServiceContext, serviceDeskManagedJiraWorkflow.workflow().getName())).toRight(() -> this.buildErrorFromCollection("Failed to create draft workflow", jiraServiceContext.getErrorCollection()))).yield((serviceDeskManagedJiraWorkflow, jiraServiceContext, workflow) -> workflow);
    }

    private Either<AnError, Unit> updateAndPublishWorkflow(CheckedUser checkedUser, JiraWorkflow jiraWorkflow) {
        JiraServiceContext jiraServiceContext = this.createJiraServiceContext(checkedUser);
        this.workflowService.updateWorkflow(jiraServiceContext, jiraWorkflow);
        if (jiraServiceContext.getErrorCollection().hasAnyErrors()) {
            return Either.left((Object)this.buildErrorFromCollection("update to publish workflow", jiraServiceContext.getErrorCollection()));
        }
        this.workflowService.overwriteActiveWorkflow(jiraServiceContext, jiraWorkflow.getName());
        if (jiraServiceContext.getErrorCollection().hasAnyErrors()) {
            return Either.left((Object)this.buildErrorFromCollection("Failed to publish workflow", jiraServiceContext.getErrorCollection()));
        }
        return Either.right((Object)Unit.Unit());
    }

    private JiraServiceContext createJiraServiceContext(CheckedUser checkedUser) {
        return new JiraServiceContextImpl(checkedUser.forJIRA());
    }

    private AnError buildErrorFromCollection(String cause, ErrorCollection errorCollection) {
        Collection errorMessages2 = errorCollection.getErrorMessages();
        Map errors = errorCollection.getErrors();
        StringBuilder sb = new StringBuilder();
        sb.append(cause).append("\n");
        if (!errorMessages2.isEmpty()) {
            sb.append("Error Messages:").append("\n");
            errorMessages2.forEach(msg -> sb.append("\t").append((String)msg).append("\n"));
        }
        if (!errors.isEmpty()) {
            sb.append("Errors:").append("\n");
            errors.forEach((key, value) -> sb.append("\t").append((String)key).append(": ").append((String)value).append("\n"));
        }
        Integer status = (Integer)Option.option((Object)ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons())).map(ErrorCollection.Reason::getHttpStatusCode).getOrElse((Object)HttpStatusCode.BAD_REQUEST);
        return this.errorResultHelper.anError(status.intValue(), sb.toString(), new Object[0]);
    }
}

