/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFManager;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackDateCFManager;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackParameters;
import com.atlassian.servicedesk.internal.api.feedback.RequestFeedbackTokenManager;
import com.atlassian.servicedesk.internal.api.feedback.ValidatedFeedbackToken;
import com.atlassian.servicedesk.internal.api.visiblefortesting.RequestFeedbackBackdoor;
import com.atlassian.servicedesk.internal.feature.feedback.RequestFeedbackInternalManager;
import com.atlassian.servicedesk.internal.feature.feedback.ValidatedFeedbackImpl;
import com.atlassian.servicedesk.internal.feature.feedback.settings.FeedbackSettingsInternalManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@Internal
public class RequestFeedbackBackdoorImpl
implements RequestFeedbackBackdoor {
    private final RequestFeedbackTokenManager requestFeedbackTokenManager;
    private final FeedbackSettingsInternalManager feedbackSettingsInternalManager;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final RequestFeedbackCFManager requestFeedbackCFManager;
    private final RequestFeedbackDateCFManager requestFeedbackDateCFManager;
    private final RequestFeedbackInternalManager requestFeedbackInternalManager;
    private final CommonErrors commonErrors;

    @Autowired
    public RequestFeedbackBackdoorImpl(RequestFeedbackTokenManager requestFeedbackTokenManager, FeedbackSettingsInternalManager feedbackSettingsInternalManager, ServiceDeskInternalManager serviceDeskManager, ProjectManager projectManager, IssueManager issueManager, RequestFeedbackCFManager requestFeedbackCFManager, RequestFeedbackDateCFManager requestFeedbackDateCFManager, RequestFeedbackInternalManager requestFeedbackInternalManager, CommonErrors commonErrors) {
        this.requestFeedbackTokenManager = requestFeedbackTokenManager;
        this.feedbackSettingsInternalManager = feedbackSettingsInternalManager;
        this.serviceDeskManager = serviceDeskManager;
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.requestFeedbackCFManager = requestFeedbackCFManager;
        this.requestFeedbackDateCFManager = requestFeedbackDateCFManager;
        this.requestFeedbackInternalManager = requestFeedbackInternalManager;
        this.commonErrors = commonErrors;
    }

    public Either<AnError, Boolean> isRequestFeedbackEnabled(String projectKey) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        if (project == null) {
            return Either.left((Object)this.commonErrors.PROJECT_NOT_FOUND());
        }
        Either<AnError, ServiceDesk> serviceDeskEither = this.serviceDeskManager.getServiceDesk(project, false);
        return serviceDeskEither.bimap(error -> this.commonErrors.SERVICEDESK_NOT_FOUND(), serviceDesk -> this.feedbackSettingsInternalManager.isFeedbackServiceEnabled((ServiceDesk)serviceDesk));
    }

    public Either<AnError, String> getFeedbackQuestion(String projectKey) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        if (project == null) {
            return Either.left((Object)this.commonErrors.PROJECT_NOT_FOUND());
        }
        Either<AnError, ServiceDesk> serviceDeskEither = this.serviceDeskManager.getServiceDesk(project, false);
        return serviceDeskEither.bimap(error -> this.commonErrors.SERVICEDESK_NOT_FOUND(), serviceDesk -> this.feedbackSettingsInternalManager.getFeedbackQuestionOrDefault((ServiceDesk)serviceDesk));
    }

    public String generateToken(String issueKey) {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        ApplicationUser applicationUser = issue.getReporterUser();
        ValidatedFeedbackToken feedbackToken = (ValidatedFeedbackToken)this.requestFeedbackTokenManager.generateFeedbackToken((Issue)issue).right().get();
        ValidatedFeedbackToken validatedFeedbackToken = new ValidatedFeedbackToken(feedbackToken.getToken(), feedbackToken.getIssueID());
        this.requestFeedbackTokenManager.storeFeedbackToken(applicationUser, validatedFeedbackToken);
        return feedbackToken.getToken();
    }

    public void registerFeedbackCustomFields() {
        this.requestFeedbackCFManager.getOrCreateRequestFeedbackCF();
        this.requestFeedbackDateCFManager.getOrCreateRequestFeedbackDateCF();
    }

    public void updateRequestFeedback(String requestKey, int rating, String comment) {
        FeedbackParameters feedbackParameters = FeedbackParameters.newBuilder().comment(Option.some((Object)comment)).rating(Integer.valueOf(rating)).build();
        ValidatedFeedbackImpl validatedFeedback = new ValidatedFeedbackImpl(feedbackParameters);
        this.requestFeedbackInternalManager.storeFeedback((Issue)this.issueManager.getIssueObject(requestKey), validatedFeedback);
    }
}

