/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.visiblefortesting.PublicSignUpBackdoor;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.GlobalPublicSignupManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@Internal
public class PublicSignUpBackdoorImpl
implements PublicSignUpBackdoor {
    private final GlobalPublicSignupManager globalPublicSignUpManager;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final InternalServiceDeskProjectManager projectManager;

    @Autowired
    public PublicSignUpBackdoorImpl(GlobalPublicSignupManager globalPublicSignUpManager, ServiceDeskInternalManager serviceDeskManager, InternalServiceDeskProjectManager projectManager) {
        this.globalPublicSignUpManager = globalPublicSignUpManager;
        this.serviceDeskManager = serviceDeskManager;
        this.projectManager = projectManager;
    }

    public void enableForProject(int projectId) {
        this.setProjectPublicSignUp(projectId, true);
    }

    public void disableForProject(int projectId) {
        this.setProjectPublicSignUp(projectId, false);
    }

    private void setProjectPublicSignUp(long projectId, boolean enable) {
        Either<AnError, ServiceDesk> failureOrServicedesk;
        Either errorOrProject = this.projectManager.getProject(Long.valueOf(projectId));
        if (errorOrProject.isRight() && (failureOrServicedesk = this.serviceDeskManager.getServiceDesk((Project)errorOrProject.right().get(), false)).isRight()) {
            this.globalPublicSignUpManager.setGlobalPublicSignup(enable);
            this.serviceDeskManager.updateAccessConfig((ServiceDesk)failureOrServicedesk.right().get(), enable, enable);
        }
    }

    public void enable() {
        this.globalPublicSignUpManager.setGlobalPublicSignup(true);
    }

    public void disable() {
        this.globalPublicSignUpManager.setGlobalPublicSignup(false);
    }

    public boolean isEnabled() {
        return this.globalPublicSignUpManager.isGlobalPublicSignupEnabled();
    }
}

