/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.visiblefortesting.ProjectPermissionBackdoor;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.ProjectMisConfiguredErrorResponse;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.ProjectPermissionSchemeResponse;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.ProjectRoleResponse;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.SchemeEntityResponse;
import com.atlassian.servicedesk.internal.permission.misconfiguration.error.MisconfigurationInformation;
import com.atlassian.servicedesk.internal.permission.restore.PermissionSchemeMisconfigurationManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskJiraRoleManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskProjectRole;
import com.atlassian.servicedesk.squalor.permissions.PermissionKeyHelper;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@Internal
public class ProjectPermissionBackdoorImpl
implements ProjectPermissionBackdoor {
    private static final Logger log = LoggerFactory.getLogger(ProjectPermissionBackdoorImpl.class);
    private final PermissionSchemeManager permissionSchemeManager;
    private final InternalServiceDeskProjectManager sdProjectManager;
    private final ServiceDeskJiraRoleManager sdRoleManager;
    private final PermissionSchemeMisconfigurationManager permissionSchemeMisconfigurationManager;
    private final I18nHelper i18nHelper;

    @Autowired
    public ProjectPermissionBackdoorImpl(PermissionSchemeManager permissionSchemeManager, InternalServiceDeskProjectManager sdProjectManager, ServiceDeskJiraRoleManager sdRoleManager, PermissionSchemeMisconfigurationManager permissionSchemeMisconfigurationManager, I18nHelper i18nHelper) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.sdProjectManager = sdProjectManager;
        this.sdRoleManager = sdRoleManager;
        this.permissionSchemeMisconfigurationManager = permissionSchemeMisconfigurationManager;
        this.i18nHelper = i18nHelper;
    }

    private Option<ProjectRole> getProjectRoleForByRoleName(String roleName) {
        Option<ServiceDeskProjectRole> serviceDeskProjectRoles = ServiceDeskProjectRole.fromRolename(roleName);
        return serviceDeskProjectRoles.flatMap(this.sdRoleManager::getRole);
    }

    private ProjectPermissionKey getPermissionKeyFromEntity(SchemeEntity entity) {
        Object entityTypeId = entity.getEntityTypeId();
        if (entityTypeId instanceof Integer) {
            return PermissionKeyHelper.newProjectPermissionKey((int)((Integer)entityTypeId));
        }
        if (entityTypeId instanceof Long) {
            return PermissionKeyHelper.newProjectPermissionKey((int)((Long)entityTypeId).intValue());
        }
        return (ProjectPermissionKey)entityTypeId;
    }

    public Either<AnError, ProjectPermissionSchemeResponse> getSchemeForProject(String projectKey) {
        Either errorOrProject = this.sdProjectManager.getProjectByKey(projectKey);
        Either errorOrSchemeResponse = errorOrProject.map(project -> {
            Scheme scheme = this.permissionSchemeManager.getSchemeFor(project);
            ArrayList<SchemeEntityResponse> permissionResults = new ArrayList<SchemeEntityResponse>();
            for (SchemeEntity entity : scheme.getEntities()) {
                permissionResults.add(new SchemeEntityResponse(entity.getId().toString(), this.getPermissionKeyFromEntity(entity).permissionKey(), entity.getParameter()));
            }
            return new ProjectPermissionSchemeResponse(scheme.getId().toString(), scheme.getName(), scheme.getName(), permissionResults);
        });
        return errorOrSchemeResponse;
    }

    public Option<ProjectRoleResponse> getProjectRole(String roleName) {
        return this.getProjectRoleForByRoleName(roleName).map(ProjectRoleResponse::new);
    }

    private List<ProjectMisConfiguredErrorResponse> toJSONResponse(List<MisconfigurationInformation> permissionConfigurationErrors) {
        ArrayList<ProjectMisConfiguredErrorResponse> projectMisConfiguredErrorResponses = new ArrayList<ProjectMisConfiguredErrorResponse>();
        for (MisconfigurationInformation error : permissionConfigurationErrors) {
            projectMisConfiguredErrorResponses.add(new ProjectMisConfiguredErrorResponse(this.i18nHelper.getText(error.getSeverity().getI18nKey()), this.i18nHelper.getText(error.getErrorMessageKey())));
        }
        return projectMisConfiguredErrorResponses;
    }

    public List<ProjectMisConfiguredErrorResponse> getMisConfigurationError(String projectKey) {
        Either errorOrProject = this.sdProjectManager.getProjectByKey(projectKey);
        return (List)errorOrProject.fold(err -> {
            log.error("getMisConfigurationError yields ServiceDeskProjectError:" + err);
            return Collections.emptyList();
        }, project -> {
            List<MisconfigurationInformation> permissionConfigurationErrors = this.permissionSchemeMisconfigurationManager.getMisconfigurationErrors((Project)project);
            return this.toJSONResponse(permissionConfigurationErrors);
        });
    }

    public Either<AnError, Scheme> restoreMisConfiguration(String projectKey) {
        Either errorOrProject = this.sdProjectManager.getProjectByKey(projectKey);
        return errorOrProject.map(this.permissionSchemeMisconfigurationManager::restore);
    }
}

