/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.visiblefortesting.OpenAccessBackdoor;
import com.atlassian.servicedesk.internal.feature.servicedesk.InternalServiceDeskAccessManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class OpenAccessBackdoorImpl
implements OpenAccessBackdoor {
    private final ServiceDeskInternalManager serviceDeskManager;
    private final InternalServiceDeskProjectManager serviceDeskProjectManager;
    private final InternalServiceDeskAccessManager internalServiceDeskAccessManager;

    @Autowired
    public OpenAccessBackdoorImpl(ServiceDeskInternalManager serviceDeskManager, InternalServiceDeskProjectManager serviceDeskProjectManager, InternalServiceDeskAccessManager internalServiceDeskAccessManager) {
        this.serviceDeskManager = serviceDeskManager;
        this.serviceDeskProjectManager = serviceDeskProjectManager;
        this.internalServiceDeskAccessManager = internalServiceDeskAccessManager;
    }

    public void enableOpenAccessForProject(long projectId) {
        this.updateAccessConfig(projectId, true);
    }

    public void disableOpenAccessForProject(long projectId) {
        this.updateAccessConfig(projectId, false);
    }

    private void updateAccessConfig(long projectId, boolean openAccess2) {
        boolean publicSignUp;
        Either projectEither = this.serviceDeskProjectManager.getProject(Long.valueOf(projectId));
        if (projectEither.isLeft()) {
            throw new RuntimeException(((AnError)projectEither.left().get()).getMessage().getMessage());
        }
        Project project = (Project)projectEither.right().get();
        Either<AnError, ServiceDesk> servicedeskEither = this.serviceDeskManager.getServiceDesk(project, false);
        if (servicedeskEither.isLeft()) {
            ErrorMessage errorMessage = ((AnError)servicedeskEither.left().get()).getMessage();
            throw new RuntimeException(errorMessage.getMessage());
        }
        ServiceDesk servicedesk = (ServiceDesk)servicedeskEither.right().get();
        Either<AnError, ServiceDesk> resultEither = this.serviceDeskManager.updateAccessConfig(servicedesk, openAccess2, publicSignUp = openAccess2 ? this.internalServiceDeskAccessManager.isProjectLevelSignupSettingEnabled(servicedesk) : false);
        if (resultEither.isLeft()) {
            throw new RuntimeException(((AnError)resultEither.left().get()).getMessage().getMessage());
        }
    }

    public boolean isOpenAccessEnabledForProject(long projectId) {
        Either projectEither = this.serviceDeskProjectManager.getProject(Long.valueOf(projectId));
        if (projectEither.isLeft()) {
            return false;
        }
        Project project = (Project)projectEither.right().get();
        Either<AnError, ServiceDesk> servicedeskEither = this.serviceDeskManager.getServiceDesk(project, false);
        if (servicedeskEither.isLeft()) {
            return false;
        }
        ServiceDesk servicedesk = (ServiceDesk)servicedeskEither.right().get();
        return this.internalServiceDeskAccessManager.isOpenAccess(servicedesk);
    }
}

