/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.visiblefortesting.KbServiceBackdoor;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseLinkImpl;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class KbServiceBackdoorImpl
implements KbServiceBackdoor {
    private final ServiceDeskInternalManager serviceDeskManager;
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;
    private final ConfluenceKnowledgeBaseManager kbManager;
    private final InternalServiceDeskProjectManager serviceDeskProjectManager;

    @Autowired
    public KbServiceBackdoorImpl(ServiceDeskInternalManager serviceDeskManager, ServiceDeskAppLinkService serviceDeskAppLinkService, ConfluenceKnowledgeBaseManager kbManager, InternalServiceDeskProjectManager serviceDeskProjectManager) {
        this.serviceDeskManager = serviceDeskManager;
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
        this.kbManager = kbManager;
        this.serviceDeskProjectManager = serviceDeskProjectManager;
    }

    public Option<AnError> addKBLink(String projectKey, String applicationLinkId, String spaceKey) {
        Either result = Steps.begin((Either)this.serviceDeskProjectManager.getProjectByKey(projectKey)).then(project -> this.serviceDeskManager.getServiceDesk((Project)project, false)).then((project, sd) -> this.serviceDeskAppLinkService.getApplicationLink(applicationLinkId)).then((project, sd, appLink) -> this.constructKBLink((ServiceDesk)sd, applicationLinkId, (ApplicationLink)appLink, spaceKey)).then((project, sd, appLink, kbLink) -> this.kbManager.addOrEditKBLink((ConfluenceKnowledgeBaseLink)kbLink, (ServiceDesk)sd)).yield((project, sd, appLink, kbLink, success) -> success);
        return result.left().toOption();
    }

    public Option<AnError> removeKBLink(String projectKey) {
        Either result = Steps.begin((Either)this.serviceDeskProjectManager.getProjectByKey(projectKey)).then(project -> this.serviceDeskManager.getServiceDesk((Project)project, false)).then((project, sd) -> this.kbManager.deleteKBLink((ServiceDesk)sd)).yield((project, sd, success) -> success);
        return result.left().toOption();
    }

    public Either<AnError, String> getPrimaryConfluenceApplicationLinkId() {
        Either applicationLinkEither = this.serviceDeskAppLinkService.getPrimaryApplicationLinkForType(ConfluenceApplicationType.class);
        return applicationLinkEither.map(appLink -> appLink.getId().get());
    }

    private Either<AnError, ConfluenceKnowledgeBaseLink> constructKBLink(ServiceDesk serviceDesk, String applicationLinkId, ApplicationLink applicationLink, String spaceKey) {
        return Either.right((Object)new ConfluenceKnowledgeBaseLinkImpl(-1, serviceDesk.getId(), applicationLinkId, applicationLink.getName(), applicationLink.getDisplayUrl().toASCIIString(), spaceKey, "", ""));
    }
}

