/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.request.CustomerRequestChannelSource;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.visiblefortesting.IssueChannelServiceBackdoor;
import com.atlassian.servicedesk.internal.channel.IssueChannelService;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class IssueChannelServiceBackdoorImpl
implements IssueChannelServiceBackdoor {
    private final IssueManager issueManager;
    private final IssueChannelService issueChannelService;
    private final IssuePropertyService issuePropertyService;
    private final UserFactory userFactory;

    @Autowired
    public IssueChannelServiceBackdoorImpl(IssueManager issueManager, IssueChannelService issueChannelService, UserFactory userFactory, IssuePropertyService issuePropertyService) {
        this.issueManager = issueManager;
        this.issueChannelService = issueChannelService;
        this.userFactory = userFactory;
        this.issuePropertyService = issuePropertyService;
    }

    public boolean setChannelToIssueProperty(SDUser user, long issueId, String channel) {
        return this.issueChannelService.setChannelToIssueProperty(user, issueId, CustomerRequestChannelSource.withValue((String)channel)).isRight();
    }

    public String getIssueChannel(SDUser user, long issueId) {
        return (String)Either.right((Object)user).flatMap(sdUser -> {
            MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(issueId));
            return this.issueChannelService.getIssueChannel((SDUser)sdUser, (Issue)issue);
        }).fold(e -> String.valueOf(e.getHttpStatusCode()), channelOpt -> (String)channelOpt.map(CustomerRequestChannelSource::value).getOrElse((Object)"unknown"));
    }

    public boolean setEmailChannelAddress(SDUser user, long issueId, String emailSource) {
        return this.issueChannelService.setEmailChannelAddress(user, issueId, emailSource);
    }

    public io.atlassian.fugue.Option<String> getEmailChannelAddress(SDUser user, long issueId) {
        return this.issueChannelService.getEmailChannelAddress(user, issueId);
    }

    public io.atlassian.fugue.Option<String> setPropertyDirectly(SDUser user, long issueId, String propertyName, String propertyValue) {
        EntityPropertyService.SetPropertyValidationResult validationResult = this.issuePropertyService.validateSetProperty(user.forJIRA(), Long.valueOf(issueId), new EntityPropertyService.PropertyInput(propertyValue, propertyName));
        this.issuePropertyService.setProperty(user.forJIRA(), validationResult);
        return this.getPropertyDirectly(user, issueId, propertyName);
    }

    public io.atlassian.fugue.Option<String> getPropertyDirectly(SDUser user, long issueId, String propertyName) {
        return StepsConverters.newerOption((Option)this.issuePropertyService.getProperty(user.forJIRA(), Long.valueOf(issueId), propertyName).getEntityProperty()).map(EntityProperty::getValue);
    }

    public boolean removeProperty(SDUser user, long issueId, String propertyName) {
        EntityPropertyService.DeletePropertyValidationResult validationResult = this.issuePropertyService.validateDeleteProperty(user.forJIRA(), Long.valueOf(issueId), propertyName);
        if (validationResult.isValid()) {
            this.issuePropertyService.deleteProperty(user.forJIRA(), validationResult);
            return true;
        }
        return false;
    }
}

