/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.utils.context;

import com.atlassian.servicedesk.api.customer.NoExceptionsCallable;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import io.atlassian.fugue.Unit;

public abstract class ReentrantThreadLocalBasedCodeContext {
    abstract ThreadLocal<Boolean> perClassStaticThreadLocal();

    protected static ThreadLocal<Boolean> newThreadLocal() {
        return ThreadLocal.withInitial(() -> false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T runInContext(NoExceptionsCallable<T> callable) {
        boolean previousState = this.perClassStaticThreadLocal().get();
        if (!this.isCurrentlyInContext()) {
            this.perClassStaticThreadLocal().set(true);
            try {
                T t = this.rteInvoke(previousState, true, callable);
                return t;
            }
            finally {
                this.perClassStaticThreadLocal().remove();
            }
        }
        return this.rteInvoke(previousState, previousState, callable);
    }

    protected Unit runInContext(Runnable runnable) {
        return this.runInContext(ReentrantThreadLocalBasedCodeContext.wrapNoExceptionsCallable((NoExceptionsCallable<com.atlassian.fugue.Unit>)FpKit.runnableToNoExceptionsCallable((Runnable)runnable)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T runOutOfContext(NoExceptionsCallable<T> callable) {
        boolean previousState = this.perClassStaticThreadLocal().get();
        if (this.isCurrentlyInContext()) {
            this.perClassStaticThreadLocal().remove();
            try {
                T t = this.rteInvoke(previousState, false, callable);
                return t;
            }
            finally {
                this.perClassStaticThreadLocal().set(previousState);
            }
        }
        return this.rteInvoke(previousState, previousState, callable);
    }

    protected Unit runOutOfContext(Runnable runnable) {
        return this.runOutOfContext(ReentrantThreadLocalBasedCodeContext.wrapNoExceptionsCallable((NoExceptionsCallable<com.atlassian.fugue.Unit>)FpKit.runnableToNoExceptionsCallable((Runnable)runnable)));
    }

    protected boolean isCurrentlyInContext() {
        return this.perClassStaticThreadLocal().get();
    }

    protected abstract void onEnteringInvocation(boolean var1, boolean var2);

    abstract void onExitingInvocation(boolean var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T rteInvoke(boolean previousState, boolean currentState, NoExceptionsCallable<T> callable) {
        try {
            this.onEnteringInvocation(previousState, currentState);
            Object object = callable.call();
            return (T)object;
        }
        finally {
            this.onExitingInvocation(previousState, currentState);
        }
    }

    private static NoExceptionsCallable<Unit> wrapNoExceptionsCallable(NoExceptionsCallable<com.atlassian.fugue.Unit> callable) {
        return () -> {
            callable.call();
            return Unit.Unit();
        };
    }
}

