/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.utils;

import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.servicedesk.api.portal.Portal;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerUrlUtil {
    public static final String SHIM_PREFIX = "/servicedesk/customershim";
    public static final List<String> SHIM_WHITE_LIST = Lists.newArrayList((Object[])new String[]{"/rest/api/1.0/labels", "/rest/servicedesk/1/user-search", "/secure/attachment", "/secure/thumbnail", "/images", "/secure/useravatar", "/secure/viewavatar"});
    private static final String CUSTOMER_URL = "/servicedesk/customer";
    private boolean customerLoginEnabled = true;
    private final WebResourceUrlProvider webResourceUrlProvider;

    @Autowired
    public CustomerUrlUtil(WebResourceUrlProvider webResourceUrlProvider) {
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    public String getRestUrl(boolean isRelative) {
        return this.getJIRABaseUrl(isRelative) + "/rest/servicedesk/1";
    }

    public String getRestUrl() {
        return this.getRestUrl(true);
    }

    public String getJIRABaseUrl(boolean isRelative) {
        return this.webResourceUrlProvider.getBaseUrl(isRelative ? UrlMode.RELATIVE : UrlMode.ABSOLUTE);
    }

    public UriBuilder getJIRABaseUrlBuilder(boolean isRelative) {
        return UriBuilder.fromUri((String)this.getJIRABaseUrl(isRelative));
    }

    public String getBaseUrl(boolean isRelative) {
        return this.getJIRABaseUrl(isRelative) + CUSTOMER_URL;
    }

    public UriBuilder getBaseUrlBuilder(boolean isRelative) {
        return UriBuilder.fromUri((String)this.getBaseUrl(isRelative));
    }

    public String getLoginUrl(boolean isRelative, String destination, Map<String, String> sdQueryParams) {
        if (this.isCustomerLoginEnabled()) {
            return this.createCustomerLoginUrl(isRelative, destination, sdQueryParams);
        }
        return this.createBaseLoginUrl(isRelative, destination);
    }

    public String getLoginUrl(Map<String, String> queryParams, boolean isRelative) {
        return this.getLoginUrl(isRelative, null, queryParams);
    }

    public String getLoginUrl(String destination) {
        return this.getLoginUrl(true, destination, null);
    }

    public String getUrl(String path, Map<String, String> queryParams, boolean isRelative) {
        UriBuilder uriBuilder = this.getBaseUrlBuilder(isRelative);
        this.addPathToUrl(path, uriBuilder);
        this.addQueryParametersToUrl(queryParams, uriBuilder);
        return uriBuilder.build(new Object[0]).toString();
    }

    public String getUrl(String path) {
        return this.getUrl(path, null, true);
    }

    public String getPortalUrl(Portal portal, String path, Map<String, String> queryParams, boolean isRelative) {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.getBaseUrl(isRelative)).path("portal").path(String.valueOf(portal.getId()));
        this.addPathToUrl(path, uriBuilder);
        this.addQueryParametersToUrl(queryParams, uriBuilder);
        return uriBuilder.build(new Object[0]).toString();
    }

    public String getPortalUrl(Portal portal, String path) {
        return this.getPortalUrl(portal, path, null, true);
    }

    public String getPortalUrlSimple(Portal portal) {
        return this.getPortalUrl(portal, null);
    }

    private void addPathToUrl(String path, UriBuilder uriBuilder) {
        if (StringUtils.isNotBlank((String)path)) {
            uriBuilder.path(path);
        }
    }

    private String createBaseLoginUrl(boolean isRelative, String destination) {
        UriBuilder builder = this.getJIRABaseUrlBuilder(isRelative).path("login.jsp");
        this.addRedirectToLoginUrl(destination, builder);
        return builder.build(new Object[0]).toString();
    }

    private String createCustomerLoginUrl(boolean isRelative, String destination, Map<String, String> sdQueryParams) {
        UriBuilder builder = this.createCustomerLoginUrlBuilder(isRelative);
        this.addDestinationToUrl(destination, builder);
        this.addQueryParametersToUrl(sdQueryParams, builder);
        return builder.build(new Object[0]).toString();
    }

    private void addRedirectToLoginUrl(String destination, UriBuilder builder) {
        String redirect = StringUtils.isNotBlank((String)destination) ? destination : "portals";
        builder.queryParam("os_destination", new Object[]{"/servicedesk/customer/" + redirect});
    }

    private UriBuilder createCustomerLoginUrlBuilder(boolean isRelative) {
        return this.getBaseUrlBuilder(isRelative).path("user").path("login");
    }

    private void addDestinationToUrl(String destination, UriBuilder builder) {
        if (StringUtils.isNotBlank((String)destination)) {
            builder.queryParam("destination", new Object[]{destination});
        }
    }

    private void addQueryParametersToUrl(Map<String, String> sdQueryParams, UriBuilder builder) {
        if (sdQueryParams == null) {
            return;
        }
        for (String queryParam : sdQueryParams.keySet()) {
            builder.queryParam(queryParam, new Object[]{sdQueryParams.get(queryParam)});
        }
    }

    public boolean isCustomerLoginEnabled() {
        return this.customerLoginEnabled;
    }

    void setCustomerLoginEnabled(boolean customerLoginEnabled) {
        this.customerLoginEnabled = customerLoginEnabled;
    }
}

