/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CacheUtil {
    private static final List<String> ILLEGAL_CACHE_NAME_CHARACTERS = Lists.newArrayList((Object[])new String[]{"$", ":"});

    public static String standardName(Object object, String cacheName) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"object is required");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)cacheName), (Object)"cacheName is required");
        Preconditions.checkArgument((boolean)CacheUtil.containsNoneOf(cacheName, ILLEGAL_CACHE_NAME_CHARACTERS), (Object)("cacheName cannot contain any of " + ILLEGAL_CACHE_NAME_CHARACTERS));
        String rawName = object.getClass().getName() + "." + cacheName;
        return CacheUtil.removeAllOf(rawName, ILLEGAL_CACHE_NAME_CHARACTERS);
    }

    private static boolean containsNoneOf(String toCheck, List<String> containsNoneOfThese) {
        for (String shouldNotContain : containsNoneOfThese) {
            if (!toCheck.contains(shouldNotContain)) continue;
            return false;
        }
        return true;
    }

    private static String removeAllOf(String toRemoveFrom, List<String> stringsToRemove) {
        String withRemovals = toRemoveFrom;
        for (String toRemove : stringsToRemove) {
            withRemovals = StringUtils.remove((String)withRemovals, (String)toRemove);
        }
        return withRemovals;
    }
}

