/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util.tokens.jwt;

import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.JwtService;
import com.atlassian.jwt.core.HttpRequestCanonicalizer;
import com.atlassian.jwt.core.TimeUtil;
import com.atlassian.jwt.core.writer.JsonSmartJwtJsonBuilder;
import com.atlassian.jwt.core.writer.JwtClaimsBuilder;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.atlassian.servicedesk.internal.util.tokens.jwt.JwtTokenGenerator;
import com.atlassian.servicedesk.internal.util.tokens.jwt.ServiceDeskJwtIssuer;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenGeneratorImpl
implements JwtTokenGenerator {
    private static final int DEFAULT_JWT_TOKEN_EXPIRY_SECOND = 2419200;
    private static final Logger logger = LoggerFactory.getLogger(JwtTokenGeneratorImpl.class);
    private final JwtService jwtService;
    private final ServiceDeskJwtIssuer jwtIssuer;

    @Autowired
    public JwtTokenGeneratorImpl(JwtService jwtService, ServiceDeskJwtIssuer jwtIssuer) {
        this.jwtService = jwtService;
        this.jwtIssuer = jwtIssuer;
    }

    @Override
    public Option<String> generateToken(@Nonnull URI targetURI, @Nonnull URI baseURI, @Nonnull String httpMethod, @Nonnull Map<String, String> contextClaim) {
        JwtJsonBuilder jsonBuilder = new JsonSmartJwtJsonBuilder().issuedAt(TimeUtil.currentTimeSeconds()).expirationTime(TimeUtil.currentTimePlusNSeconds((long)2419200L)).issuer(this.jwtIssuer.getName()).claim("context", contextClaim);
        ImmutableMap.Builder completeParams = ImmutableMap.builder();
        try {
            if (!StringUtils.isEmpty((String)targetURI.getQuery())) {
                completeParams.putAll(this.constructParameterMap(targetURI));
            }
            CanonicalHttpUriRequest request = new CanonicalHttpUriRequest(httpMethod, targetURI.toString(), baseURI.toString(), (Map)completeParams.build());
            logger.debug("Canonical request is: " + HttpRequestCanonicalizer.canonicalize((CanonicalHttpRequest)request));
            JwtClaimsBuilder.appendHttpRequestClaims((JwtJsonBuilder)jsonBuilder, (CanonicalHttpRequest)request);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Failed to generate token due to UnsupportedEncoding");
            return Option.none();
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Failed to generate token due to NoSuchAlgorithm");
            return Option.none();
        }
        String secret = this.jwtIssuer.getSharedSecret();
        if (secret == null) {
            logger.warn("Failed to generate token due to no available secretkey");
            return Option.none();
        }
        return Option.some((Object)this.jwtService.issueJwt(jsonBuilder.build(), secret));
    }

    private Map<String, String[]> constructParameterMap(URI uri) throws UnsupportedEncodingException {
        ImmutableMap.Builder queryParams = ImmutableMap.builder();
        List nameValuePairs = URLEncodedUtils.parse((URI)uri, (String)"UTF-8");
        nameValuePairs.stream().filter(pair -> StringUtils.isNotBlank((String)pair.getName())).forEach(pair -> queryParams.put((Object)pair.getName(), (Object)new String[]{pair.getValue()}));
        return queryParams.build();
    }
}

