/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util.tokens;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.util.tokens.UnsubscribeTokenGenerator;
import com.atlassian.servicedesk.internal.util.tokens.jwt.JwtTokenGenerator;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnsubscribeTokenGeneratorImpl
implements UnsubscribeTokenGenerator {
    private final JwtTokenGenerator jwtTokenGenerator;
    private final PortalUrlsProvider portalUrlsProvider;
    private final JiraBaseUrls jiraBaseUrls;

    @Autowired
    public UnsubscribeTokenGeneratorImpl(JwtTokenGenerator jwtTokenGenerator, PortalUrlsProvider portalUrlsProvider, JiraBaseUrls jiraBaseUrls) {
        this.jwtTokenGenerator = jwtTokenGenerator;
        this.portalUrlsProvider = portalUrlsProvider;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @Override
    public Option<String> generateToken(@Nonnull Issue issue, @Nonnull Portal portal, @Nonnull CheckedUser user) {
        URI unsubscribeURI = this.getUnsubscribeUrl(portal, issue);
        URI baseURI = UriBuilder.fromUri((String)this.jiraBaseUrls.baseUrl()).build(new Object[0]);
        Map<String, String> contextClaim = this.buildUnsubscribeContextClaim(issue, user);
        return this.jwtTokenGenerator.generateToken(unsubscribeURI, baseURI, "GET", contextClaim);
    }

    private URI getUnsubscribeUrl(Portal portal, Issue issue) {
        return this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE).unsubscribe(issue.getKey());
    }

    private Map<String, String> buildUnsubscribeContextClaim(Issue issue, CheckedUser user) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)"user", (Object)user.getKey()).put((Object)"issue", (Object)issue.getKey());
        return mapBuilder.build();
    }
}

