/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util.permission;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.internal.api.util.CollectorsHelper;
import com.atlassian.servicedesk.internal.api.util.permission.PermissionSchemeHelper;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerServiceValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class PermissionSchemeHelperImpl
implements PermissionSchemeHelper {
    private final PermissionSchemeManager permissionSchemeManager;
    private final PermissionContextFactory permissionContextFactory;
    private final CustomerContextService customerContextService;

    @Autowired
    public PermissionSchemeHelperImpl(PermissionSchemeManager permissionSchemeManager, PermissionContextFactory permissionContextFactory, CustomerContextService customerContextService) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.permissionContextFactory = permissionContextFactory;
        this.customerContextService = customerContextService;
    }

    @VisibleForTesting
    Collection<ApplicationUser> getUsersByPermissions(Collection<ProjectPermissionKey> permissionKeys, Project project) {
        if (permissionKeys.isEmpty()) {
            return Collections.emptySet();
        }
        PermissionContext permissionContext = this.permissionContextFactory.getPermissionContext(project);
        List usersOptionList = permissionKeys.stream().map(permissionKey -> Option.option((Object)this.permissionSchemeManager.getUsers(permissionKey, permissionContext)).map(Sets::newHashSet)).collect(Collectors.toList());
        if (Iterables.any(usersOptionList, Option::isEmpty)) {
            return Collections.emptySet();
        }
        Queue collect = (Queue)usersOptionList.stream().flatMap(usersOption -> StreamSupport.stream(usersOption.spliterator(), false)).sorted(Comparator.comparingInt(Set::size)).collect(CollectorsHelper.toQueue());
        Set result = (Set)collect.poll();
        if (result == null) {
            return Collections.emptySet();
        }
        Set users = (Set)collect.poll();
        while (users != null) {
            result = Sets.intersection((Set)result, (Set)users);
            users = (Set)collect.poll();
        }
        return ImmutableList.copyOf((Collection)result);
    }

    public Collection<ApplicationUser> getUsersByPermissionsInCustomerContext(Collection<ProjectPermissionKey> permissionKeys, Project project) {
        return (Collection)this.customerContextService.runInCustomerContext(() -> this.getUsersByPermissions(permissionKeys, project));
    }

    public Collection<ApplicationUser> getUsersByPermissionsOutOfCustomerContext(Collection<ProjectPermissionKey> permissionKeys, Project project) {
        return (Collection)this.customerContextService.runOutOfCustomerContext(() -> this.getUsersByPermissions(permissionKeys, project));
    }

    public Collection<ApplicationUser> getCustomerUsersByPermissions(Project project) {
        return this.getUsersByPermissionsInCustomerContext(CustomerServiceValidator.CREATE_REQUEST_REQUIRED_PROJECT_PERMISSIONS, project);
    }
}

