/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util.paging;

import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.internal.util.paging.LazyPagedResponse;
import com.google.common.base.Function;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class LazyPagedResponseImpl<T>
implements LazyPagedResponse<T> {
    private final int total;
    private final PagedResponse<T> delegate;

    protected LazyPagedResponseImpl(PagedResponse<T> delegate, int total) {
        this.delegate = delegate;
        this.total = total;
    }

    public static <T> LazyPagedResponse<T> from(PagedResponse<T> pagedResponse) {
        PagedRequest request = pagedResponse.getPagedRequest();
        int start = request != null ? request.getStart() : 0;
        return LazyPagedResponseImpl.from(pagedResponse, start + pagedResponse.size());
    }

    public static <T> LazyPagedResponse<T> from(PagedResponse<T> pagedResponse, int total) {
        return new LazyPagedResponseImpl<T>(pagedResponse, total);
    }

    @Override
    public int total() {
        return this.total;
    }

    public List<T> getResults() {
        return this.delegate.getResults();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean hasNextPage() {
        return this.delegate.hasNextPage();
    }

    public PagedRequest getPagedRequest() {
        return this.delegate.getPagedRequest();
    }

    public <M> PagedResponse<M> map(Function<T, M> mapper) {
        return this.delegate.map(mapper);
    }

    public Optional<T> findFirst() {
        return this.delegate.findFirst();
    }

    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }
}

