/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.function.issue.UpdateIssueFieldFunction;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.util.WorkflowHelper;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.TypeResolver;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class WorkflowHelperImpl
implements WorkflowHelper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FIELD_NAME = "field.name";
    private final WorkflowService workflowService;
    private final ProjectService projectService;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ErrorResultHelper errorHelper;

    @Autowired
    public WorkflowHelperImpl(WorkflowService workflowService, ProjectService projectService, WorkflowSchemeManager workflowSchemeManager, JiraAuthenticationContext authenticationContext, ErrorResultHelper errorHelper) {
        this.workflowService = workflowService;
        this.projectService = projectService;
        this.workflowSchemeManager = workflowSchemeManager;
        this.authenticationContext = authenticationContext;
        this.errorHelper = errorHelper;
    }

    private Supplier<AnError> orError(AnError anError) {
        return () -> anError;
    }

    public Either<AnError, JiraWorkflow> getDraftWorkflow(ApplicationUser user, String workflowName) {
        JiraServiceContext serviceContext = this.getServiceContext(user);
        return Option.option((Object)this.workflowService.getDraftWorkflow(serviceContext, workflowName)).toRight(this.orError(this.WORKFLOW_NOT_FOUND()));
    }

    public Either<AnError, StepDescriptor> getStepByStatusId(JiraWorkflow workflow, long statusId) {
        return Option.option((Object)workflow).map(JiraWorkflow::getDescriptor).map(WorkflowDescriptor::getSteps).flatMap(steps -> this.getStep(workflow, statusId, (List)steps)).toRight(this.orError(this.WORKFLOW_STATUS_NOT_FOUND()));
    }

    public List<StepDescriptor> getStatusSteps(JiraWorkflow workflow) {
        List steps = workflow.getDescriptor().getSteps();
        return steps.stream().filter(stepDescriptor -> Option.option((Object)workflow.getLinkedStatus(stepDescriptor)).isDefined()).collect(Collectors.toList());
    }

    public Either<AnError, ActionDescriptor> getActionByTransitionId(JiraWorkflow workflow, int transitionId) {
        return Option.option((Object)workflow).map(JiraWorkflow::getDescriptor).map(workflowDescriptor -> workflowDescriptor.getAction(transitionId)).toRight(this.orError(this.WORKFLOW_TRANSITION_NOT_FOUND()));
    }

    public List<ActionDescriptor> getAllActions(JiraWorkflow workflow) {
        return workflow.getAllActions().stream().collect(Collectors.toList());
    }

    public List<ActionDescriptor> getInitialActions(JiraWorkflow workflow) {
        return (List)Option.option((Object)workflow.getDescriptor()).map(desc -> desc.getInitialActions()).getOrElse(Collections.emptyList());
    }

    public List<Project> getProjectsForWorkflow(String workflowName) {
        Multimap<String, Project> workflow = this.getProjectsForWorkflow(Collections.singleton(workflowName));
        return Lists.newArrayList((Iterable)workflow.get((Object)workflowName));
    }

    public Either<AnError, JiraWorkflow> saveWorkflow(JiraWorkflow workflow) {
        ErrorCollection saveWorkflowErrors;
        try {
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authenticationContext.getLoggedInUser());
            this.workflowService.updateWorkflow((JiraServiceContext)serviceContext, workflow);
            saveWorkflowErrors = serviceContext.getErrorCollection();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return Either.left((Object)this.WORKFLOW_SAVE_FAILED());
        }
        if (saveWorkflowErrors.hasAnyErrors()) {
            this.logger.warn("Saving workflow failed due to errors");
            return Either.left((Object)this.WORKFLOW_SAVE_FAILED());
        }
        return Either.right((Object)workflow);
    }

    private Option<StepDescriptor> getStep(JiraWorkflow draftWorkflow, long statusId, List steps) {
        for (Object obj : steps) {
            StepDescriptor step;
            Status linkedStatus;
            if (!(obj instanceof StepDescriptor) || (linkedStatus = draftWorkflow.getLinkedStatus(step = (StepDescriptor)obj)) == null || Long.parseLong(linkedStatus.getId()) != statusId) continue;
            return Option.option((Object)step);
        }
        return Option.none();
    }

    private JiraServiceContext getServiceContext(ApplicationUser user) {
        return new JiraServiceContextImpl(user);
    }

    private Multimap<String, Project> getProjectsForWorkflow(Set<String> workflows) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Project project : this.getAllProjects()) {
            Map workflowMap = this.workflowSchemeManager.getWorkflowMap(project);
            String defaultWorkflow = (String)workflowMap.get(null);
            if (defaultWorkflow == null) {
                defaultWorkflow = "jira";
            }
            for (IssueType type : project.getIssueTypes()) {
                String workflow = (String)workflowMap.get(type.getId());
                if (workflow == null) {
                    workflow = defaultWorkflow;
                }
                if (!workflows.contains(workflow)) continue;
                result.put((Object)workflow, (Object)project);
            }
        }
        return result;
    }

    private List<Project> getAllProjects() {
        ServiceOutcome projectsForAction = this.projectService.getAllProjectsForAction(this.authenticationContext.getLoggedInUser(), ProjectAction.EDIT_PROJECT_CONFIG);
        if (projectsForAction.isValid()) {
            return (List)projectsForAction.getReturnedValue();
        }
        return Collections.emptyList();
    }

    public List<FunctionDescriptor> getPostFunctionsWhichAffectResolution(Option<JiraWorkflow> workflowOpt, int transitionId) {
        if (!workflowOpt.isDefined()) {
            return Collections.emptyList();
        }
        JiraWorkflow workflow = (JiraWorkflow)workflowOpt.get();
        Option actionDescriptorOption = this.getActionByTransitionId(workflow, transitionId).toOption();
        if (!actionDescriptorOption.isDefined()) {
            return Collections.emptyList();
        }
        return workflow.getPostFunctionsForTransition((ActionDescriptor)actionDescriptorOption.get()).stream().filter(this::isPostfunctionWhichAffectsResolution).collect(Collectors.toList());
    }

    public boolean hasAPostFunctionWhichAffectsResolution(Option<JiraWorkflow> workflowOpt, int transitionId) {
        if (!workflowOpt.isDefined()) {
            return false;
        }
        JiraWorkflow workflow = (JiraWorkflow)workflowOpt.get();
        Option actionDescriptorOption = this.getActionByTransitionId(workflow, transitionId).toOption();
        return (Boolean)actionDescriptorOption.map(actionDescriptor -> workflow.getPostFunctionsForTransition(actionDescriptor).stream().anyMatch(this::isPostfunctionWhichAffectsResolution)).getOrElse((Object)false);
    }

    private boolean isPostfunctionWhichAffectsResolution(FunctionDescriptor function) {
        String type = function.getType();
        Map args = function.getArgs();
        if ("resolution".equals(args.get(FIELD_NAME))) {
            try {
                FunctionProvider provider = TypeResolver.getResolver().getFunction(type, args);
                return provider instanceof UpdateIssueFieldFunction;
            }
            catch (WorkflowException e) {
                return false;
            }
        }
        return false;
    }

    private AnError WORKFLOW_TRANSITION_NOT_FOUND() {
        return this.errorHelper.badRequest400("sd.workflow.error.workflow.transition.not.found", new Object[0]).build();
    }

    private AnError WORKFLOW_STATUS_NOT_FOUND() {
        return this.errorHelper.badRequest400("sd.workflow.error.workflow.status.not.found", new Object[0]).build();
    }

    private AnError WORKFLOW_NOT_FOUND() {
        return this.errorHelper.badRequest400("sd.workflow.error.workflow.not.found", new Object[0]).build();
    }

    private AnError WORKFLOW_SAVE_FAILED() {
        return this.errorHelper.internalServiceError500("sd.workflow.error.workflow.save.failed", new Object[0]).build();
    }
}

