/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util;

import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.bootstrap.lifecycle.LifecycleLock;
import io.atlassian.fugue.Option;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SafeRunner {
    private static final Logger log = Logger.getLogger(SafeRunner.class);
    LifecycleLock lifecycleLock;

    @Autowired
    public SafeRunner(LifecycleLock lifecycleLock) {
        this.lifecycleLock = lifecycleLock;
    }

    public void run(Runnable eventHandler) {
        Callable<Option<Void>> pluginLifecycleSafeCallable = this.lifecycleLock.withPluginLifecycleSafety(() -> {
            eventHandler.run();
            return null;
        });
        SafePluginPointAccess.call(pluginLifecycleSafeCallable);
    }

    public <T> Option<T> call(Callable<T> callable) {
        Option nestedOpt = StepsConverters.newerOption((com.atlassian.fugue.Option)SafePluginPointAccess.call(this.lifecycleLock.withPluginLifecycleSafety(callable)));
        return (Option)nestedOpt.getOrElse((Object)Option.none());
    }

    public void runAlways(String handlerCodeDesc, Runnable eventHandler) {
        this.withTryCatchCondom(handlerCodeDesc, eventHandler);
    }

    private void withTryCatchCondom(String handlerCodeDesc, Runnable eventHandler) {
        try {
            eventHandler.run();
        }
        catch (Exception e) {
            log.error((Object)String.format("Unable to run event handler %s", handlerCodeDesc), (Throwable)e);
        }
    }
}

