/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util;

import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.VCacheUtils;
import com.google.gson.Gson;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SafeJsonExternalCacheReader {
    private static final Gson GSON = new Gson();
    private final Logger log = LoggerFactory.getLogger(SafeJsonExternalCacheReader.class);

    public <T> T read(DirectExternalCache<String> cache, Class<T> resultClazz, String cacheKey, Supplier<T> cacheLoader) {
        Option cachedResult = (Option)VCacheUtils.fold((CompletionStage)cache.get(cacheKey, () -> GSON.toJson(cacheLoader.get())), result -> Option.some((Object)result), error -> {
            this.log.error("Retrieving a value from the '{}' external cache failed: {}", (Object)cache.getName(), error);
            return Option.none();
        });
        return (T)cachedResult.fold(() -> {
            Object value = cacheLoader.get();
            this.updateCacheUnconditionally(cache, cacheKey, GSON.toJson(value));
            return value;
        }, result -> {
            try {
                return GSON.fromJson(result, resultClazz);
            }
            catch (RuntimeException gsonException) {
                this.log.error("Unable to deserialise the value of {} returned from the '{}' external cache: {}", new Object[]{resultClazz, cache.getName(), gsonException});
                return cacheLoader.get();
            }
        });
    }

    private void updateCacheUnconditionally(DirectExternalCache<String> cache, String cacheKey, String value) {
        VCacheUtils.fold((CompletionStage)cache.put(cacheKey, (Object)value, PutPolicy.PUT_ALWAYS), result -> Unit.Unit(), error -> {
            this.log.error("Failed to update the '{}' external cache: {}", (Object)cache.getName(), error);
            return Unit.Unit();
        });
    }
}

