/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import io.atlassian.fugue.Option;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectContextHelper {
    private static final Pattern EDIT_QUEUE_URI = Pattern.compile("projects/[a-zA-Z]+/queues/custom/\\d+/edit");
    private final ProjectManager projectManager;

    @Autowired
    public ProjectContextHelper(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public Option<Project> getProjectFromEditQueueContext() {
        String currentUri;
        Matcher matcher;
        Option currentUriOpt = Option.option((Object)ExecutingHttpRequest.get()).map(request -> request.getHeader("Referer"));
        if (currentUriOpt.isDefined() && (matcher = EDIT_QUEUE_URI.matcher(currentUri = (String)currentUriOpt.get())).find()) {
            String matched = matcher.group();
            String projectKey = matched.split("/")[1];
            return Option.option((Object)this.projectManager.getProjectObjByKey(projectKey));
        }
        return Option.none();
    }
}

