/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueEventTypeHelper {
    public static final long DEFAULT_TYPE_ID = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(IssueEventTypeHelper.class);
    private final EventTypeManager eventTypeManager;

    @Autowired
    public IssueEventTypeHelper(EventTypeManager eventTypeManager) {
        this.eventTypeManager = eventTypeManager;
    }

    public boolean isEventOfType(@Nonnull IssueEvent issueEvent, Long eventTypeId) {
        return Objects.equals(issueEvent.getEventTypeId(), eventTypeId) || Objects.equals(this.getBaseEventTypeId(issueEvent), eventTypeId);
    }

    public Long getBaseEventTypeId(@Nonnull IssueEvent issueEvent) {
        try {
            EventType eventType = this.eventTypeManager.getEventType(issueEvent.getEventTypeId());
            if (eventType != null) {
                return eventType.getTemplateId();
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error("Could not determine event type.", (Throwable)ex);
        }
        return -1L;
    }
}

