/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CheckedSoyTemplateRendererAnalyticsHelper {
    private static final String IMPROPER_ACCESS_EVENT = "servicedesk.soy.improper.plugin.template.access";
    private final AnalyticsService analyticsService;

    @Autowired
    CheckedSoyTemplateRendererAnalyticsHelper(AnalyticsService analyticsService) {
        this.analyticsService = analyticsService;
    }

    void fireAnalyticsEvent(String completeModuleKey, String templateName) {
        CheckedSoyTemplateAnalyticsEvent event = new CheckedSoyTemplateAnalyticsEvent(IMPROPER_ACCESS_EVENT, completeModuleKey, templateName);
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)event);
    }

    public class CheckedSoyTemplateAnalyticsEvent
    extends AnalyticsEvent {
        private final String eventName;
        private final String completeModuleKey;
        private final String templateName;

        CheckedSoyTemplateAnalyticsEvent(String eventName, String completeModuleKey, String templateName) {
            this.eventName = eventName;
            this.completeModuleKey = completeModuleKey;
            this.templateName = templateName;
        }

        @EventName
        public String getEventName() {
            return this.eventName;
        }

        public String getCompleteModuleKey() {
            return this.completeModuleKey;
        }

        public String getTemplateName() {
            return this.templateName;
        }
    }
}

