/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.user.permission.roles;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskJiraRoleManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskProjectRole;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskJiraRoleManagerImpl
implements ServiceDeskJiraRoleManager {
    private static final Logger log = LoggerFactory.getLogger(ServiceDeskJiraRoleManager.class);
    private final I18nHelper.BeanFactory i18nFactory;
    private final ErrorResultHelper errorResultHelper;
    private final ApplicationProperties applicationProperties;
    private final ProjectRoleManager projectRoleManager;
    private final RoleActorFactory roleActorFactory;

    @Autowired
    public ServiceDeskJiraRoleManagerImpl(ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nFactory, ErrorResultHelper errorResultHelper, ProjectRoleManager projectRoleManager, RoleActorFactory roleActorFactory) {
        this.applicationProperties = applicationProperties;
        this.i18nFactory = i18nFactory;
        this.errorResultHelper = errorResultHelper;
        this.projectRoleManager = projectRoleManager;
        this.roleActorFactory = roleActorFactory;
    }

    @Override
    public Either<AnError, CheckedUser> addUserToRole(CheckedUser user, Project project, ServiceDeskProjectRole serviceDeskProjectRole) {
        String errorKey;
        ProjectRole projectRole = this.getOrCreateRole(serviceDeskProjectRole);
        switch (serviceDeskProjectRole) {
            case CUSTOMER: {
                errorKey = "sd.role.customer.add.fails";
                break;
            }
            case TEAM: {
                errorKey = "sd.role.agent.add.fails";
                break;
            }
            case ADMIN: {
                errorKey = "sd.role.admin.add.fails";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ServiceDeskProjectRole to add : " + (Object)((Object)serviceDeskProjectRole));
            }
        }
        return this.doAddUserToRole(user, project, projectRole, errorKey);
    }

    @Override
    public Either<AnError, CheckedUser> addUserToRoleThroughInvite(CheckedUser user, Project project, ServiceDeskProjectRole serviceDeskProjectRole) {
        String errorKey;
        ProjectRole projectRole = this.getOrCreateRole(serviceDeskProjectRole);
        switch (serviceDeskProjectRole) {
            case CUSTOMER: {
                errorKey = "sd.agent.people.customers.invite.error.add.user.to.customer.role";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ServiceDeskProjectRole to add through invite : " + (Object)((Object)serviceDeskProjectRole));
            }
        }
        return this.doAddUserToRole(user, project, projectRole, errorKey);
    }

    @Override
    public Either<AnError, JSDSuccess> removeUserFromRole(CheckedUser user, Project project, ServiceDeskProjectRole serviceDeskProjectRole) {
        String errorKey;
        ArrayList allServiceDeskProjectRoles = Lists.newArrayList((Object[])new ServiceDeskProjectRole[]{serviceDeskProjectRole});
        switch (serviceDeskProjectRole) {
            case CUSTOMER: {
                errorKey = "sd.role.customer.remove.fails";
                break;
            }
            case TEAM: {
                allServiceDeskProjectRoles.add(ServiceDeskProjectRole.ADMIN);
                errorKey = "sd.role.agent.remove.fails";
                break;
            }
            case ADMIN: {
                errorKey = "sd.role.admin.remove.fails";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ServiceDeskProjectRole to remove : " + (Object)((Object)serviceDeskProjectRole));
            }
        }
        ArrayList projectRoleActorsList = Lists.newArrayList();
        for (ServiceDeskProjectRole additionalServiceDeskProjectRole : allServiceDeskProjectRoles) {
            ProjectRole projectRole = this.getOrCreateRole(additionalServiceDeskProjectRole);
            projectRoleActorsList.add(Pair.pair((Object)projectRole, (Object)Option.option((Object)this.projectRoleManager.getProjectRoleActors(projectRole, project))));
        }
        if (projectRoleActorsList.stream().map(Pair::right).anyMatch(Option::isEmpty)) {
            return Either.left((Object)this.errorResultHelper.badRequest400(errorKey, new Object[0]).build());
        }
        projectRoleActorsList.forEach(actorsPair -> this.simpleRemoveFromRoleHelper((ProjectRoleActors)((Option)actorsPair.right()).get(), user, (ProjectRole)actorsPair.left(), project));
        return Either.right((Object)((Object)JSDSuccess.success()));
    }

    @Override
    public boolean isUserInRole(CheckedUser user, Project project, ServiceDeskProjectRole serviceDeskProjectRole) {
        return this.getRole(serviceDeskProjectRole).exists(role -> this.projectRoleManager.isUserInProjectRole(user.forJIRA(), role, project));
    }

    @Override
    public Set<ApplicationUser> getAllUsersInRole(Project project, ServiceDeskProjectRole serviceDeskProjectRole) {
        return (Set)this.getRole(serviceDeskProjectRole).fold(Collections::emptySet, role -> this.projectRoleManager.getProjectRoleActors(role, project).getApplicationUsers());
    }

    @Override
    public ProjectRole getOrCreateRole(ServiceDeskProjectRole serviceDeskProjectRole) {
        ProjectRole projectRole = this.createRoleTemplate(serviceDeskProjectRole);
        return this.createRole(projectRole);
    }

    @Override
    public Option<ProjectRole> getRole(ServiceDeskProjectRole serviceDeskProjectRole) {
        try {
            return Option.option((Object)this.projectRoleManager.getProjectRole(serviceDeskProjectRole.getRolename()));
        }
        catch (IllegalArgumentException e) {
            return Option.none();
        }
    }

    private ProjectRole createRoleTemplate(ServiceDeskProjectRole serviceDeskProjectRole) {
        String i18nKey;
        switch (serviceDeskProjectRole) {
            case CUSTOMER: {
                i18nKey = "sd.role.create.description.customer";
                break;
            }
            case TEAM: {
                i18nKey = "sd.role.create.description.team";
                break;
            }
            case ADMIN: {
                i18nKey = "sd.role.create.description.administrator";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ServiceDeskProjectRole to create project role template : " + (Object)((Object)serviceDeskProjectRole));
            }
        }
        return new ProjectRoleImpl(serviceDeskProjectRole.getRolename(), this.i18nFactory.getInstance(this.applicationProperties.getDefaultLocale()).getText(i18nKey));
    }

    private ProjectRole createRole(ProjectRole roleTemplate) {
        Option projectRole = Option.option((Object)this.projectRoleManager.getProjectRole(roleTemplate.getName()));
        return (ProjectRole)projectRole.getOrElse(() -> {
            log.info("Creating project role {}", (Object)roleTemplate.getName());
            return this.projectRoleManager.createRole(roleTemplate);
        });
    }

    private ProjectRoleActor createRoleActor(CheckedUser user, ProjectRole role, Project project) {
        try {
            return this.roleActorFactory.createRoleActor(null, role.getId(), project.getId(), "atlassian-user-role-actor", user.getKey());
        }
        catch (RoleActorDoesNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    private Either<AnError, CheckedUser> doAddUserToRole(CheckedUser userToAdd, Project project, ProjectRole projectRole, String errorKey) {
        Either projectRoleActors = Option.option((Object)this.projectRoleManager.getProjectRoleActors(projectRole, project)).toRight(() -> this.errorResultHelper.badRequest400(errorKey, new Object[0]).build());
        return projectRoleActors.map(actors -> {
            this.simpleAddToRoleHelper((ProjectRoleActors)actors, userToAdd, projectRole, project);
            return userToAdd;
        });
    }

    private void simpleAddToRoleHelper(ProjectRoleActors current, CheckedUser toAdd, ProjectRole role, Project project) {
        ProjectRoleActor actorsToAdd = this.createRoleActor(toAdd, role, project);
        DefaultRoleActors updatedActors = current.addRoleActor((RoleActor)actorsToAdd);
        this.updateRoleActors(updatedActors);
    }

    private void simpleRemoveFromRoleHelper(ProjectRoleActors current, CheckedUser toRemove, ProjectRole role, Project project) {
        ProjectRoleActor actorsToRemove = this.createRoleActor(toRemove, role, project);
        DefaultRoleActors updatedActors = current.removeRoleActor((RoleActor)actorsToRemove);
        this.updateRoleActors(updatedActors);
    }

    private void updateRoleActors(DefaultRoleActors updatedActors) {
        if (updatedActors instanceof ProjectRoleActors) {
            this.projectRoleManager.updateProjectRoleActors((ProjectRoleActors)updatedActors);
        } else {
            this.projectRoleManager.updateDefaultRoleActors(updatedActors);
        }
    }
}

