/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.user.license;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskApplicationLicenseService;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskUserLicenseServiceImpl
implements ServiceDeskUserLicenseService {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDeskUserLicenseServiceImpl.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserService userService;
    private final ApplicationAuthorizationService applicationAuthorizationService;
    private final ServiceDeskApplicationLicenseService serviceDeskApplicationLicenseService;
    private final ApplicationRoleManager applicationRoleManager;

    @Autowired
    public ServiceDeskUserLicenseServiceImpl(JiraAuthenticationContext jiraAuthenticationContext, UserService userService, ApplicationAuthorizationService applicationAuthorizationService, ServiceDeskApplicationLicenseService serviceDeskApplicationLicenseService, ApplicationRoleManager applicationRoleManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userService = userService;
        this.applicationAuthorizationService = applicationAuthorizationService;
        this.serviceDeskApplicationLicenseService = serviceDeskApplicationLicenseService;
        this.applicationRoleManager = applicationRoleManager;
    }

    @Override
    public Set<Group> getAgentGroups() {
        return (Set)this.applicationRoleManager.getRole(ServiceDeskApplicationLicenseService.SERVICEDESK_KEY).map(ApplicationRole::getGroups).getOrElse(Collections.emptySet());
    }

    @Override
    public boolean hasValidAgentLicense(@Nullable ApplicationUser user) {
        if (this.serviceDeskApplicationLicenseService.isAgentLimitExceeded()) {
            return false;
        }
        return this.hasAgentLicense(user);
    }

    @Override
    public boolean hasValidAgentLicense(@Nonnull SDUser user) {
        return this.hasValidAgentLicense(user.forJIRA());
    }

    private boolean hasAgentLicense(ApplicationUser user) {
        return this.applicationAuthorizationService.canUseApplication(user, ServiceDeskApplicationLicenseService.SERVICEDESK_KEY);
    }

    @Override
    public ErrorCollection grantAgentAccess(@Nullable ApplicationUser user) {
        SimpleErrorCollection errors;
        block3: {
            ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
            UserService.AddUserToApplicationValidationResult result = this.userService.validateAddUserToApplication(loggedInUser, user, ServiceDeskApplicationLicenseService.SERVICEDESK_KEY);
            if (!result.isValid()) {
                return result.getErrorCollection();
            }
            errors = new SimpleErrorCollection();
            try {
                this.userService.addUserToApplication(result);
            }
            catch (AddException | PermissionException e) {
                logger.error("Error adding user to default groups assigned to ServiceDesk Application: ", e);
                if (this.hasAgentLicense(user)) break block3;
                errors.addErrorMessage(e.getMessage());
            }
        }
        return errors;
    }
}

