/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.user;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Eithers;
import com.atlassian.fugue.Option;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.user.CheckedUserImpl;
import com.atlassian.servicedesk.internal.user.UncheckedUserImpl;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNullableByDefault
@ReturnValuesAreNonnullByDefault
public class UserFactoryImpl
implements UserFactory {
    private final ErrorResultHelper errorResultHelper;
    private final I18nHelper.BeanFactory i18nFactory;
    private final UserManager userManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CommonErrors commonErrors;

    @Autowired
    public UserFactoryImpl(ErrorResultHelper errorResultHelper, I18nHelper.BeanFactory i18nFactory, UserManager userManager, JiraAuthenticationContext jiraAuthenticationContext, CommonErrors commonErrors) {
        this.errorResultHelper = errorResultHelper;
        this.i18nFactory = i18nFactory;
        this.userManager = userManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.commonErrors = commonErrors;
    }

    public Either<AnError, UncheckedUser> wrapUnchecked(ApplicationUser appUser) {
        return Either.right((Object)new UncheckedUserImpl(appUser, this.i18nFactory.getInstance(appUser)));
    }

    public Either<AnError, CheckedUser> wrap(ApplicationUser appUser) {
        return Option.option((Object)appUser).map(user -> new CheckedUserImpl((ApplicationUser)user, this.i18nFactory.getInstance(user))).toRight(() -> this.errorResultHelper.anError(401, "sd.admin.servicedesk.error.authenticated.user.required", new Object[0]));
    }

    public Either<AnError, List<CheckedUser>> wrap(Collection<ApplicationUser> appUsers) {
        List checkedUsers = appUsers.stream().map(this::wrap).collect(Collectors.toList());
        return Eithers.sequenceRight(checkedUsers).map(Lists::newArrayList);
    }

    public Either<AnError, CheckedUser> wrapUsername(String username) {
        return Option.option((Object)this.userManager.getUserByName(username)).toRight(() -> ((CommonErrors)this.commonErrors).USER_NOT_EXIST_ERROR()).flatMap(this::wrap);
    }

    public Either<AnError, List<CheckedUser>> wrapUsernames(Collection<String> usernames) {
        Objects.requireNonNull(usernames, "usernames");
        List checkedUsers = usernames.stream().map(this::wrapUsername).collect(Collectors.toList());
        return Eithers.sequenceRight(checkedUsers).map(Lists::newArrayList);
    }

    public Either<AnError, CheckedUser> wrapUserKey(String userkey) {
        return Option.option((Object)this.userManager.getUserByKey(userkey)).toRight(() -> ((CommonErrors)this.commonErrors).USER_NOT_EXIST_ERROR()).flatMap(this::wrap);
    }

    public Either<AnError, List<ApplicationUser>> unwrap(Collection<CheckedUser> checkedUsers) {
        return Either.right(checkedUsers.stream().map(CheckedUser::forJIRA).collect(Collectors.toList()));
    }

    public Either<AnError, CheckedUser> getCheckedUser() {
        return this.wrap(this.jiraAuthenticationContext.getLoggedInUser());
    }

    @Nonnull
    public UncheckedUser getUncheckedUser() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return new UncheckedUserImpl(user, this.i18nFactory.getInstance(user));
    }
}

