/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.user;

import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.internal.user.CheckedUserImpl;
import com.google.common.base.MoreObjects;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UncheckedUserImpl
implements UncheckedUser {
    private final ApplicationUser delegate;
    private final I18nHelper i18nHelper;

    public UncheckedUserImpl(ApplicationUser delegate, I18nHelper i18nHelper) {
        this.delegate = delegate;
        this.i18nHelper = i18nHelper;
    }

    public boolean isAnonymous() {
        return this.delegate == null;
    }

    @Nullable
    public ApplicationUser forJIRA() {
        return this.delegate;
    }

    public I18nHelper i18NHelper() {
        return this.i18nHelper;
    }

    public Locale getLocale() {
        return this.i18nHelper.getLocale();
    }

    @Nonnull
    public Option<CheckedUser> asCheckedUser() {
        return Option.option((Object)this.delegate).map(user -> new CheckedUserImpl((ApplicationUser)user, this.i18nHelper));
    }

    public boolean equals(Object o) {
        ApplicationUser that;
        if (o instanceof ApplicationUser) {
            that = (ApplicationUser)o;
        } else if (o instanceof UncheckedUser) {
            that = ((UncheckedUser)o).forJIRA();
        } else {
            return false;
        }
        return Objects.equals(this.delegate, that);
    }

    public int hashCode() {
        return Objects.hashCode(this.delegate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("delegate", (Object)(this.delegate == null ? "Anonymous" : this.delegate)).add("i18nHelper", (Object)this.i18nHelper).toString();
    }
}

