/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.user;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.internal.user.UncheckedUserImpl;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CheckedUserImpl
implements CheckedUser {
    private final ApplicationUser delegate;
    private final I18nHelper i18nHelper;

    public CheckedUserImpl(ApplicationUser delegate, I18nHelper i18nHelper) {
        Preconditions.checkNotNull((Object)delegate, (Object)"JIRA User cannot be anonymous or null");
        this.delegate = delegate;
        this.i18nHelper = i18nHelper;
    }

    public boolean isAnonymous() {
        return false;
    }

    @Nonnull
    public ApplicationUser forJIRA() {
        return this.delegate;
    }

    public I18nHelper i18NHelper() {
        return this.i18nHelper;
    }

    public Locale getLocale() {
        return this.i18nHelper.getLocale();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getKey() {
        return this.delegate.getKey();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String getEmailAddress() {
        return this.delegate.getEmailAddress();
    }

    @Nonnull
    public UncheckedUser asUncheckedUser() {
        return new UncheckedUserImpl(this.delegate, this.i18nHelper);
    }

    public boolean equals(Object o) {
        ApplicationUser that;
        if (o instanceof ApplicationUser) {
            that = (ApplicationUser)o;
        } else if (o instanceof CheckedUser) {
            that = ((CheckedUser)o).forJIRA();
        } else {
            return false;
        }
        return Objects.equals(this.delegate, that);
    }

    public int hashCode() {
        return Objects.hashCode(this.delegate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("delegate", (Object)this.delegate).add("i18nHelper", (Object)this.i18nHelper).toString();
    }
}

