/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.upgrade;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.bootstrap.version.BuildProperties;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTask;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTaskResult;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.upgrade.AsyncUpgradeTaskRecord;
import com.atlassian.servicedesk.internal.upgrade.AsyncUpgradeTaskRecordQStore;
import com.atlassian.servicedesk.internal.utils.DateTimeUtils;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncUpgradeTaskRecordQStoreImpl
implements AsyncUpgradeTaskRecordQStore {
    private static final String STARTED = "STARTED";
    private static final String COMPLETED = "COMPLETED";
    private static final String FAILED = "FAILED";
    private final DatabaseAccessor databaseAccessor;
    private final BuildProperties buildProperties;

    @Autowired
    public AsyncUpgradeTaskRecordQStoreImpl(DatabaseAccessor databaseAccessor, BuildProperties buildProperties) {
        this.databaseAccessor = databaseAccessor;
        this.buildProperties = buildProperties;
    }

    @Override
    public List<AsyncUpgradeTaskRecord> getRecords() {
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)conn.select(AsyncUpgradeTaskRecordQStoreImpl.MAPPER()).from((Expression)Tables.ASYNC_UPGRADE_RECORD)).fetch());
    }

    @Override
    public void writeStartRecord(Class<? extends AsyncUpgradeTask> taskClass) {
        this.writeRecord(taskClass, STARTED, "", "");
    }

    @Override
    public void writeCompleteRecord(Class<? extends AsyncUpgradeTask> taskClass, AsyncUpgradeTaskResult result) {
        this.writeRecord(taskClass, COMPLETED, (String)result.getMessage().getOrElse((Object)""), "");
    }

    @Override
    public void writeFailureRecord(Class<? extends AsyncUpgradeTask> taskClass, Option<String> failureMessage, Option<String> exception) {
        this.writeRecord(taskClass, FAILED, (String)failureMessage.getOrElse((Object)""), (String)exception.getOrElse((Object)""));
    }

    @Override
    public boolean hasTaskCompleted(Class<? extends AsyncUpgradeTask> taskClass) {
        return this.hasTaskCompleted(taskClass.getSimpleName());
    }

    @Override
    public boolean hasTaskCompleted(String taskName) {
        return (Boolean)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select(Tables.ASYNC_UPGRADE_RECORD.ID).from((Expression)Tables.ASYNC_UPGRADE_RECORD)).where((Predicate)Tables.ASYNC_UPGRADE_RECORD.UPGRADE_TASK_NAME.eq((Object)taskName).and((Predicate)Tables.ASYNC_UPGRADE_RECORD.ACTION.eq((Object)COMPLETED)))).fetchCount() > 0L);
    }

    private static ConstructorExpression<AsyncUpgradeTaskRecord> MAPPER() {
        return Projections.constructor(AsyncUpgradeTaskRecord.class, (Expression[])new Expression[]{Tables.ASYNC_UPGRADE_RECORD.UPGRADE_TASK_NAME, Tables.ASYNC_UPGRADE_RECORD.CREATED_DATE, Tables.ASYNC_UPGRADE_RECORD.ACTION, Tables.ASYNC_UPGRADE_RECORD.SERVICE_DESK_VERSION, Tables.ASYNC_UPGRADE_RECORD.MESSAGE});
    }

    private void writeRecord(Class<? extends AsyncUpgradeTask> taskClass, String action, String message, String exception) {
        this.databaseAccessor.runInTransaction(conn -> conn.insert((RelationalPath)Tables.ASYNC_UPGRADE_RECORD).set(Tables.ASYNC_UPGRADE_RECORD.CREATED_DATE, (Object)DateTimeUtils.getCurrentTimestamp()).set((Path)Tables.ASYNC_UPGRADE_RECORD.SERVICE_DESK_VERSION, (Object)this.buildProperties.getVersion()).set((Path)Tables.ASYNC_UPGRADE_RECORD.UPGRADE_TASK_NAME, (Object)taskClass.getSimpleName()).set((Path)Tables.ASYNC_UPGRADE_RECORD.ACTION, (Object)action).set((Path)Tables.ASYNC_UPGRADE_RECORD.MESSAGE, (Object)message).set((Path)Tables.ASYNC_UPGRADE_RECORD.EXCEPTION, (Object)exception).execute());
    }
}

