/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.timedpromise.taskrunner;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseConfig;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseKey;
import com.atlassian.scheduler.timedpromise.api.task.TimedPromiseTaskRequest;
import com.atlassian.scheduler.timedpromise.api.task.TimedPromiseTaskResponse;
import com.atlassian.scheduler.timedpromise.api.task.TimedPromiseTaskRunner;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.sla.data.SlaDataManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;

public class SlaThresholdEventTaskRunner
implements TimedPromiseTaskRunner {
    public static final String TASK_RUNNER_KEY = "com.atlassian.servicedesk.sla.threshold.event.task.runner";
    public static final String TASK_CLASSIFICATION = "servicedesk.sla.threshold.event";
    public static final String TASK_COMPONENT_ISSUE_ID = "issue.id";
    private final IssueManager issueManager;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final SlaDataManager slaDataManager;

    public SlaThresholdEventTaskRunner(IssueManager issueManager, ServiceDeskInternalManager serviceDeskManager, SlaDataManager slaDataManager) {
        this.issueManager = issueManager;
        this.serviceDeskManager = serviceDeskManager;
        this.slaDataManager = slaDataManager;
    }

    public TimedPromiseTaskResponse executeTask(@Nonnull TimedPromiseTaskRequest timedPromiseTaskRequest) {
        Option<String> issueIdOpt = this.getIssueId(timedPromiseTaskRequest);
        if (issueIdOpt.isEmpty()) {
            return TimedPromiseTaskResponse.failed((String)"Issue ID was not found in the time promise request");
        }
        Option<Issue> issueOpt = this.getIssue((String)issueIdOpt.get());
        if (issueOpt.isEmpty()) {
            return TimedPromiseTaskResponse.failed((String)("Could not load the issue with id: " + (String)issueIdOpt.get()));
        }
        Issue issue = (Issue)issueOpt.get();
        Either<AnError, ServiceDesk> serviceDeskEither = this.serviceDeskManager.getServiceDesk(issue.getProjectObject(), false);
        if (serviceDeskEither.isLeft()) {
            return TimedPromiseTaskResponse.failed((String)"Could not load the Service Desk");
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskEither.right().get();
        Option<DateTime> nextExceedingSlaThresholdTime = this.slaDataManager.processSlasFromTimedPromiseAndGetRescheduleTime(issue, serviceDesk);
        if (nextExceedingSlaThresholdTime.isDefined()) {
            return TimedPromiseTaskResponse.successAndReschedule((String)("SLA Threshold Events - successfully executed timed promise for issue " + issue.getKey() + " (rescheduling a future timed promise for next threshold...)"), (TimedPromiseConfig)SlaThresholdEventTaskRunner.buildTimedPromiseConfig(((DateTime)nextExceedingSlaThresholdTime.get()).getMillis()));
        }
        return TimedPromiseTaskResponse.success((String)("SLA Threshold Events - successfully executed timed promise for issue " + issue.getKey()));
    }

    public static TimedPromiseKey buildTimedPromiseKey(Issue issue) {
        return TimedPromiseKey.builder().taskRunnerKey(TASK_RUNNER_KEY).classification(TASK_CLASSIFICATION).component(TASK_COMPONENT_ISSUE_ID, String.valueOf(issue.getId())).build();
    }

    public static TimedPromiseConfig buildTimedPromiseConfig(long earliestNextSlaThresholdEventTime) {
        return TimedPromiseConfig.builder().invocationTime(earliestNextSlaThresholdEventTime).build();
    }

    private Option<String> getIssueId(TimedPromiseTaskRequest timedPromiseTaskRequest) {
        return StepsConverters.newerOption((com.atlassian.fugue.Option)timedPromiseTaskRequest.getTimedPromiseKey().getComponents().get(TASK_COMPONENT_ISSUE_ID));
    }

    private Option<Issue> getIssue(String issueId) {
        MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(issueId));
        return Option.option((Object)issue);
    }
}

