/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.spam;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.requests.SignUpRequest;
import com.atlassian.servicedesk.internal.spam.AntispamProtectionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AntispamProtectionServiceImpl
implements AntispamProtectionService {
    private final FeatureManager featureManager;
    private final AnalyticsService analyticsService;

    @Autowired
    public AntispamProtectionServiceImpl(FeatureManager featureManager, AnalyticsService analyticsService) {
        this.featureManager = featureManager;
        this.analyticsService = analyticsService;
    }

    @Override
    public boolean validateCustomerSignUpRequest(SignUpRequest request) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.HELP_CENTER_CUSTOMER_SIGNUP_HONEYPOT)) {
            return true;
        }
        if (request.getSecondaryEmail().exists(String::isEmpty)) {
            return true;
        }
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new HoneypotTrapAnalyticsEvent());
        return false;
    }

    @EventName(value="servicedesk.portal.customer.signup.honeypot")
    private static class HoneypotTrapAnalyticsEvent
    extends AnalyticsEvent {
        private HoneypotTrapAnalyticsEvent() {
        }
    }
}

