/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.soy;

import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.util.ServiceDeskApplicationVersionUtil;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.internal.soy.SoyRenderingHelper;
import com.google.common.collect.ImmutableMap;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.collection.Iterable;

@Component
public class SoyRenderingHelperImpl
implements SoyRenderingHelper {
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final ServiceDeskApplicationVersionUtil serviceDeskApplicationVersionUtil;
    private final I18nHelper i18nHelper;

    @Autowired
    public SoyRenderingHelperImpl(SoyTemplateRenderer soyTemplateRenderer, WebResourceUrlProvider webResourceUrlProvider, ServiceDeskApplicationVersionUtil serviceDeskApplicationVersionUtil, I18nHelper i18nHelper) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.serviceDeskApplicationVersionUtil = serviceDeskApplicationVersionUtil;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public void requireErrorResources() {
        JiraWebResourceManager jiraWebResourceManager = (JiraWebResourceManager)ComponentAccessor.getComponent(JiraWebResourceManager.class);
        jiraWebResourceManager.requireResourcesForContext("sd.error.page");
    }

    @Override
    public void renderSoy(String templateAddress, Appendable appendable, Map<String, Object> params) {
        Map<String, Object> allParams = this.withBaseParams(params);
        this.validateTemplateParams(allParams);
        TemplateNameAndCompleteModuleKey templateNameAndCompleteModuleKey = SoyRenderingHelperImpl.extractTemplateNameAndModuleKey(templateAddress);
        this.soyTemplateRenderer.render(appendable, templateNameAndCompleteModuleKey.completeModuleKey, templateNameAndCompleteModuleKey.templateName, allParams);
    }

    @Override
    public StreamingOutput streamSoy(String templateAddress, Map<String, Object> params) {
        return output -> {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(output, "UTF-8"));
            this.renderSoy(templateAddress, printWriter, params);
            printWriter.flush();
        };
    }

    @Override
    public void renderErrorWithSDLink(Appendable appendable, String i18nErrorKey, List<String> i18nErrorParams, Project lastViewedServiceDesk) {
        String translatedMessage = this.i18nHelper.getText(i18nErrorKey, i18nErrorParams);
        this.requireErrorResources();
        ImmutableMap params = ImmutableMap.builder().put((Object)"error", (Object)translatedMessage).put((Object)"lastSDKey", (Object)lastViewedServiceDesk.getKey()).put((Object)"lastSDName", (Object)lastViewedServiceDesk.getName()).build();
        this.renderSoy("com.atlassian.servicedesk:soy/ServiceDesk.Templates.Errors.errorPageWithSDLink", appendable, (Map<String, Object>)params);
    }

    @Override
    public void renderBasicError(Appendable appendable, String i18nErrorKey, List<String> i18nErrorParams) {
        String translatedMessage = this.i18nHelper.getText(i18nErrorKey, i18nErrorParams);
        this.renderError(appendable, translatedMessage);
    }

    @Override
    public void renderBasicError(Appendable output, AnError error) {
        ErrorMessage message = error.getMessage();
        io.atlassian.fugue.Option i18n = StepsConverters.newerOption((Option)message.getI18n());
        String translated = (String)i18n.fold(() -> ((ErrorMessage)message).getMessage(), input -> this.i18nHelper.getText(input.getI18nKey(), (Object)input.getParams()));
        this.renderError(output, translated);
    }

    private void renderError(Appendable appendable, String translatedMessage) {
        this.requireErrorResources();
        this.renderSoy("com.atlassian.servicedesk:soy/ServiceDesk.Templates.Errors.errorPage", appendable, (Map<String, Object>)ImmutableMap.of((Object)"error", (Object)translatedMessage));
    }

    private Map<String, Object> withBaseParams(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(params);
        result.putIfAbsent("viewportBase", this.webResourceUrlProvider.getBaseUrl() + "/servicedesk");
        result.putIfAbsent("jiraBase", this.webResourceUrlProvider.getBaseUrl());
        result.putIfAbsent("jiraBaseAbsolute", this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE));
        result.putIfAbsent("pluginVersion", this.serviceDeskApplicationVersionUtil.getServiceDeskApplicationVersion());
        return Collections.unmodifiableMap(result);
    }

    private void validateTemplateParams(Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (!(entry.getValue() instanceof Iterable)) continue;
            throw new IllegalArgumentException(String.format("Non-soyable Scala sequence for '%s': [%s]", entry.getKey(), entry.getValue()));
        }
    }

    private static TemplateNameAndCompleteModuleKey extractTemplateNameAndModuleKey(String templateAddress) {
        String templateName;
        String moduleKey;
        if (templateAddress.contains("/")) {
            String[] splitBySlash = templateAddress.split("/");
            moduleKey = splitBySlash[0];
            templateName = splitBySlash[1];
        } else {
            moduleKey = "soy";
            templateName = templateAddress;
        }
        String completeModuleKey = moduleKey.contains(":") ? moduleKey : String.format("%s:%s", "com.atlassian.servicedesk", moduleKey);
        return new TemplateNameAndCompleteModuleKey(templateName, completeModuleKey);
    }

    private static class TemplateNameAndCompleteModuleKey {
        final String templateName;
        final String completeModuleKey;

        TemplateNameAndCompleteModuleKey(String templateName, String completeModuleKey) {
            this.templateName = templateName;
            this.completeModuleKey = completeModuleKey;
        }
    }
}

