/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.soy;

import com.atlassian.jira.issue.RendererManager;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerTextInternalRenderer;
import com.atlassian.servicedesk.internal.soy.RenderOption;
import com.atlassian.servicedesk.internal.soy.RichTextRenderer;
import io.atlassian.fugue.Option;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class RichTextRendererImpl
implements RichTextRenderer {
    private final RendererManager rendererManager;
    private final CustomerTextInternalRenderer customerTextRenderer;

    @Autowired
    public RichTextRendererImpl(RendererManager rendererManager, CustomerTextInternalRenderer customerTextRenderer) {
        this.rendererManager = rendererManager;
        this.customerTextRenderer = customerTextRenderer;
    }

    @Override
    public String renderWiki(String wiki, RenderOption ... renderOptions) {
        String sanitized = StringEscapeUtils.escapeHtml((String)wiki);
        String wikiHtml = this.rendererManager.getRendererForType("atlassian-wiki-renderer").render(sanitized, null);
        String wikiHtmlWithRenderOptionsApplied = this.applyRenderOptions(wikiHtml, renderOptions);
        return wikiHtmlWithRenderOptionsApplied;
    }

    private String applyRenderOptions(String wikiHtml, RenderOption ... options) {
        for (RenderOption option : options) {
            wikiHtml = option.apply(wikiHtml);
        }
        return wikiHtml;
    }

    @Override
    public String renderCustomerWiki(String wiki, Option<CheckedUser> user, RenderOption ... renderOptions) {
        String wikiHtml = this.renderWiki(wiki, renderOptions);
        return this.customerTextRenderer.updateTextForCustomer(wikiHtml, user, Option.none());
    }
}

