/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.util;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.api.sla.metric.TimeMetricMeasureType;
import com.atlassian.servicedesk.internal.api.sla.util.SlaDurationFormatter;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class SlaDurationFormatterImpl
implements SlaDurationFormatter {
    private static final long ONE_SECOND_MILLIS = 1000L;
    private static final long ONE_MINUTE_SECONDS = 60L;
    private static final long ONE_HOUR_MINUTES = 60L;
    public static final int ROUND_UP_POSITIVE_TRIGGER = 30;
    public static final int ROUND_UP_NEGATIVE_TRIGGER = -30;
    @Autowired
    private I18nHelper.BeanFactory i18nFactory;

    public String getShortFormattedRemainingDuration(long duration, ApplicationUser user) {
        return this.getDefaultShortFormat(duration, user);
    }

    public String getLongFormattedRemainingDuration(long duration, ApplicationUser user) {
        return this.getDefaultLongFormat(duration, user);
    }

    public String getShortFormattedGoalDuration(long duration, ApplicationUser user) {
        return this.getDefaultShortFormat(duration, user);
    }

    public String getLongFormattedGoalDuration(long duration, ApplicationUser user) {
        return this.getDefaultLongFormat(duration, user);
    }

    public String getRemainingTimeInDaysAndMillisFormatted(Map<TimeMetricMeasureType, Long> remainingTimeInDaysAndMillis, ApplicationUser user) {
        if (remainingTimeInDaysAndMillis == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.i18nFactory.getInstance(user).getText("sd.sla.duration.days.short", (Object)remainingTimeInDaysAndMillis.get(TimeMetricMeasureType.DAYS)));
        result.append(this.i18nFactory.getInstance(user).getText("sd.sla.duration.hours.short", (Object)this.convertMillisecondsToHours(remainingTimeInDaysAndMillis.get(TimeMetricMeasureType.REMAINING_MILLIS_WITHIN_DAY))));
        return result.toString();
    }

    private String getDefaultShortFormat(long duration, ApplicationUser user) {
        boolean isNegative;
        long positiveDuration = duration;
        boolean bl = isNegative = duration < 0L;
        if (isNegative) {
            positiveDuration = -duration;
        }
        int totalNbMinutes = this.getRoundedMinutes(positiveDuration);
        int nbMinutesInHour = (int)((long)totalNbMinutes % 60L);
        int nbHours = (int)((long)totalNbMinutes / 60L);
        StringBuilder sb = new StringBuilder();
        if (isNegative && (nbHours > 0 || nbMinutesInHour > 0)) {
            sb.append("-");
        }
        sb.append(nbHours).append(":");
        if (nbMinutesInHour < 10) {
            sb.append("0");
        }
        sb.append(nbMinutesInHour);
        return sb.toString();
    }

    private String getDefaultLongFormat(long duration, ApplicationUser user) {
        int totalNbMinutes = this.getRoundedMinutes(duration);
        int nbMinutesInHour = (int)((long)totalNbMinutes % 60L);
        int nbHours = (int)((long)totalNbMinutes / 60L);
        StringBuilder result = new StringBuilder();
        if (nbHours != 0) {
            result.append(this.i18nFactory.getInstance(user).getText("sd.sla.duration.hours.short", (Object)nbHours));
            if (nbMinutesInHour != 0) {
                result.append(" ");
                result.append(this.i18nFactory.getInstance(user).getText("sd.sla.duration.minutes.short", (Object)Math.abs(nbMinutesInHour)));
            }
        } else {
            result.append(this.i18nFactory.getInstance(user).getText("sd.sla.duration.minutes.short", (Object)nbMinutesInHour));
        }
        return result.toString();
    }

    private int getRoundedMinutes(long duration) {
        int totalNbMinutes = (int)(duration / 60000L);
        if (Math.abs(totalNbMinutes) >= 1) {
            return totalNbMinutes;
        }
        long seconds = duration / 1000L % 60L;
        if (seconds >= 30L) {
            return 1;
        }
        if (seconds <= -30L) {
            return -1;
        }
        return 0;
    }

    private long convertMillisecondsToHours(long milliseconds) {
        return milliseconds / 3600000L;
    }
}

