/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.urgencylevel;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.workinprogressapi.sla.urgencylevel.UrgencyLevel;
import com.atlassian.servicedesk.workinprogressapi.sla.urgencylevel.UrgencyLevelService;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class UrgencyLevelServiceImpl
implements UrgencyLevelService {
    @TenantAware(value=TenancyScope.TENANTLESS)
    private static final Map<Long, UrgencyLevel> urgencyLevelMap = new ImmutableMap.Builder().put((Object)BREACHED_REMAINING_TIME_THRESHOLD_MILLIS, (Object)UrgencyLevel.BREACHED).put((Object)AT_RISK_REMAINING_TIME_THRESHOLD_MILLIS, (Object)UrgencyLevel.AT_RISK).put((Object)DUE_SOON_REMAINING_TIME_THRESHOLD_MILLIS, (Object)UrgencyLevel.DUE_SOON).build();

    @Override
    public Option<UrgencyLevel> getUrgencyLevelMatchingThreshold(long remainingTimeThreshold) {
        if (urgencyLevelMap.containsKey(remainingTimeThreshold)) {
            return Option.some((Object)urgencyLevelMap.get(remainingTimeThreshold));
        }
        return Option.none();
    }

    @Override
    public Option<UrgencyLevel> getUrgencyLevelForRemainingTime(long remainingTime) {
        Long targetThreshold = null;
        for (Long threshold : this.getUrgencyLevelThresholds()) {
            if (threshold < remainingTime) continue;
            targetThreshold = threshold;
        }
        if (targetThreshold == null) {
            return Option.none();
        }
        return this.getUrgencyLevelMatchingThreshold(targetThreshold);
    }

    @Override
    public Option<Long> getRemainingTimeThresholdForUrgencyLevel(TimeMetric timeMetric, UrgencyLevel urgencyLevel) {
        for (Map.Entry<Long, UrgencyLevel> entry : urgencyLevelMap.entrySet()) {
            if (!urgencyLevel.equals(entry.getValue())) continue;
            return Option.some((Object)entry.getKey());
        }
        return Option.none();
    }

    private List<Long> getUrgencyLevelThresholds() {
        ArrayList<Long> thresholds = new ArrayList<Long>(urgencyLevelMap.keySet());
        Collections.sort(thresholds);
        Collections.reverse(thresholds);
        return Collections.unmodifiableList(thresholds);
    }
}

